@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.inputs

import com.pulumi.alicloud.ess.inputs.EciScalingConfigurationInitContainerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property args The arguments passed to the commands.
 * @property commands The commands run by the init container.
 * @property cpu The amount of CPU resources allocated to the container.
 * @property environmentVars The structure of environmentVars.
 * See `environment_vars` below for details.
 * @property gpu The number GPUs.
 * @property image The image of the container.
 * @property imagePullPolicy The restart policy of the image.
 * @property memory The amount of memory resources allocated to the container.
 * @property name The name of the mounted volume.
 * @property ports The structure of port. See `ports` below for details.
 * @property securityContextCapabilityAdds Grant certain permissions to processes within container. Optional values:
 * - NET_ADMIN: Allow network management tasks to be performed.
 * - NET_RAW: Allow raw sockets.
 * @property securityContextReadOnlyRootFileSystem Mounts the container's root filesystem as read-only.
 * @property securityContextRunAsUser Specifies user ID  under which all processes run.
 * @property volumeMounts The structure of volumeMounts. See `volume_mounts` below for details.
 * @property workingDir The working directory of the container.
 */
public data class EciScalingConfigurationInitContainerArgs(
    public val args: Output<List<String>>? = null,
    public val commands: Output<List<String>>? = null,
    public val cpu: Output<Double>? = null,
    public val environmentVars: Output<List<EciScalingConfigurationInitContainerEnvironmentVarArgs>>? =
        null,
    public val gpu: Output<Int>? = null,
    public val image: Output<String>? = null,
    public val imagePullPolicy: Output<String>? = null,
    public val memory: Output<Double>? = null,
    public val name: Output<String>? = null,
    public val ports: Output<List<EciScalingConfigurationInitContainerPortArgs>>? = null,
    public val securityContextCapabilityAdds: Output<List<String>>? = null,
    public val securityContextReadOnlyRootFileSystem: Output<Boolean>? = null,
    public val securityContextRunAsUser: Output<Int>? = null,
    public val volumeMounts: Output<List<EciScalingConfigurationInitContainerVolumeMountArgs>>? =
        null,
    public val workingDir: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.inputs.EciScalingConfigurationInitContainerArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.inputs.EciScalingConfigurationInitContainerArgs =
        com.pulumi.alicloud.ess.inputs.EciScalingConfigurationInitContainerArgs.builder()
            .args(args?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .commands(commands?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .environmentVars(
                environmentVars?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .gpu(gpu?.applyValue({ args0 -> args0 }))
            .image(image?.applyValue({ args0 -> args0 }))
            .imagePullPolicy(imagePullPolicy?.applyValue({ args0 -> args0 }))
            .memory(memory?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .ports(ports?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .securityContextCapabilityAdds(
                securityContextCapabilityAdds?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .securityContextReadOnlyRootFileSystem(
                securityContextReadOnlyRootFileSystem?.applyValue({ args0 ->
                    args0
                }),
            )
            .securityContextRunAsUser(securityContextRunAsUser?.applyValue({ args0 -> args0 }))
            .volumeMounts(
                volumeMounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .workingDir(workingDir?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EciScalingConfigurationInitContainerArgs].
 */
@PulumiTagMarker
public class EciScalingConfigurationInitContainerArgsBuilder internal constructor() {
    private var args: Output<List<String>>? = null

    private var commands: Output<List<String>>? = null

    private var cpu: Output<Double>? = null

    private var environmentVars: Output<List<EciScalingConfigurationInitContainerEnvironmentVarArgs>>? =
        null

    private var gpu: Output<Int>? = null

    private var image: Output<String>? = null

    private var imagePullPolicy: Output<String>? = null

    private var memory: Output<Double>? = null

    private var name: Output<String>? = null

    private var ports: Output<List<EciScalingConfigurationInitContainerPortArgs>>? = null

    private var securityContextCapabilityAdds: Output<List<String>>? = null

    private var securityContextReadOnlyRootFileSystem: Output<Boolean>? = null

    private var securityContextRunAsUser: Output<Int>? = null

    private var volumeMounts: Output<List<EciScalingConfigurationInitContainerVolumeMountArgs>>? =
        null

    private var workingDir: Output<String>? = null

    /**
     * @param value The arguments passed to the commands.
     */
    @JvmName("nikyywyxamwqjixl")
    public suspend fun args(`value`: Output<List<String>>) {
        this.args = value
    }

    @JvmName("dlwxofabjdsqigrc")
    public suspend fun args(vararg values: Output<String>) {
        this.args = Output.all(values.asList())
    }

    /**
     * @param values The arguments passed to the commands.
     */
    @JvmName("kxwdopewgpscuafa")
    public suspend fun args(values: List<Output<String>>) {
        this.args = Output.all(values)
    }

    /**
     * @param value The commands run by the init container.
     */
    @JvmName("pamsbiqciajepxrj")
    public suspend fun commands(`value`: Output<List<String>>) {
        this.commands = value
    }

    @JvmName("qfbmfldxftmypyyb")
    public suspend fun commands(vararg values: Output<String>) {
        this.commands = Output.all(values.asList())
    }

    /**
     * @param values The commands run by the init container.
     */
    @JvmName("lchjsblagvmfcdvp")
    public suspend fun commands(values: List<Output<String>>) {
        this.commands = Output.all(values)
    }

    /**
     * @param value The amount of CPU resources allocated to the container.
     */
    @JvmName("ldcttdissfnhxlqq")
    public suspend fun cpu(`value`: Output<Double>) {
        this.cpu = value
    }

    /**
     * @param value The structure of environmentVars.
     * See `environment_vars` below for details.
     */
    @JvmName("ropwcfdgcfkurtkw")
    public suspend fun environmentVars(`value`: Output<List<EciScalingConfigurationInitContainerEnvironmentVarArgs>>) {
        this.environmentVars = value
    }

    @JvmName("ofoahwqlfxjosbeq")
    public suspend fun environmentVars(vararg values: Output<EciScalingConfigurationInitContainerEnvironmentVarArgs>) {
        this.environmentVars = Output.all(values.asList())
    }

    /**
     * @param values The structure of environmentVars.
     * See `environment_vars` below for details.
     */
    @JvmName("cvcpqdgqpcogusth")
    public suspend fun environmentVars(values: List<Output<EciScalingConfigurationInitContainerEnvironmentVarArgs>>) {
        this.environmentVars = Output.all(values)
    }

    /**
     * @param value The number GPUs.
     */
    @JvmName("hoiaoedvdninverx")
    public suspend fun gpu(`value`: Output<Int>) {
        this.gpu = value
    }

    /**
     * @param value The image of the container.
     */
    @JvmName("aguqipuhcsrkmrhf")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value The restart policy of the image.
     */
    @JvmName("uacqwffdcflrraao")
    public suspend fun imagePullPolicy(`value`: Output<String>) {
        this.imagePullPolicy = value
    }

    /**
     * @param value The amount of memory resources allocated to the container.
     */
    @JvmName("yqfkdqjaimdoafho")
    public suspend fun memory(`value`: Output<Double>) {
        this.memory = value
    }

    /**
     * @param value The name of the mounted volume.
     */
    @JvmName("nwfaeojwpjcsuetc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The structure of port. See `ports` below for details.
     */
    @JvmName("fuieflbfqbddqcpo")
    public suspend fun ports(`value`: Output<List<EciScalingConfigurationInitContainerPortArgs>>) {
        this.ports = value
    }

    @JvmName("rvwtwbesksqnxnhh")
    public suspend fun ports(vararg values: Output<EciScalingConfigurationInitContainerPortArgs>) {
        this.ports = Output.all(values.asList())
    }

    /**
     * @param values The structure of port. See `ports` below for details.
     */
    @JvmName("skdalupfragtfxut")
    public suspend fun ports(values: List<Output<EciScalingConfigurationInitContainerPortArgs>>) {
        this.ports = Output.all(values)
    }

    /**
     * @param value Grant certain permissions to processes within container. Optional values:
     * - NET_ADMIN: Allow network management tasks to be performed.
     * - NET_RAW: Allow raw sockets.
     */
    @JvmName("verqxdqljiavjeuv")
    public suspend fun securityContextCapabilityAdds(`value`: Output<List<String>>) {
        this.securityContextCapabilityAdds = value
    }

    @JvmName("mwmfxjvdlgqdweql")
    public suspend fun securityContextCapabilityAdds(vararg values: Output<String>) {
        this.securityContextCapabilityAdds = Output.all(values.asList())
    }

    /**
     * @param values Grant certain permissions to processes within container. Optional values:
     * - NET_ADMIN: Allow network management tasks to be performed.
     * - NET_RAW: Allow raw sockets.
     */
    @JvmName("hmedhwmysokmdtod")
    public suspend fun securityContextCapabilityAdds(values: List<Output<String>>) {
        this.securityContextCapabilityAdds = Output.all(values)
    }

    /**
     * @param value Mounts the container's root filesystem as read-only.
     */
    @JvmName("dwhlfastjyeqpkqm")
    public suspend fun securityContextReadOnlyRootFileSystem(`value`: Output<Boolean>) {
        this.securityContextReadOnlyRootFileSystem = value
    }

    /**
     * @param value Specifies user ID  under which all processes run.
     */
    @JvmName("fhxuschyekdxtipb")
    public suspend fun securityContextRunAsUser(`value`: Output<Int>) {
        this.securityContextRunAsUser = value
    }

    /**
     * @param value The structure of volumeMounts. See `volume_mounts` below for details.
     */
    @JvmName("cnpjaewarjmtdhal")
    public suspend fun volumeMounts(`value`: Output<List<EciScalingConfigurationInitContainerVolumeMountArgs>>) {
        this.volumeMounts = value
    }

    @JvmName("fcahiltagcnjeykg")
    public suspend fun volumeMounts(vararg values: Output<EciScalingConfigurationInitContainerVolumeMountArgs>) {
        this.volumeMounts = Output.all(values.asList())
    }

    /**
     * @param values The structure of volumeMounts. See `volume_mounts` below for details.
     */
    @JvmName("tkwiojjehxlqveec")
    public suspend fun volumeMounts(values: List<Output<EciScalingConfigurationInitContainerVolumeMountArgs>>) {
        this.volumeMounts = Output.all(values)
    }

    /**
     * @param value The working directory of the container.
     */
    @JvmName("vsuhfuacyxebfxkg")
    public suspend fun workingDir(`value`: Output<String>) {
        this.workingDir = value
    }

    /**
     * @param value The arguments passed to the commands.
     */
    @JvmName("qbikjbwmtdiljdca")
    public suspend fun args(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param values The arguments passed to the commands.
     */
    @JvmName("tihmdjefihfmxnqw")
    public suspend fun args(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param value The commands run by the init container.
     */
    @JvmName("akxovefykcqcfukt")
    public suspend fun commands(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param values The commands run by the init container.
     */
    @JvmName("uhhrcreuobwsadmh")
    public suspend fun commands(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param value The amount of CPU resources allocated to the container.
     */
    @JvmName("revfipfwubrpkqwn")
    public suspend fun cpu(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value The structure of environmentVars.
     * See `environment_vars` below for details.
     */
    @JvmName("twwenyywmbwgkksl")
    public suspend fun environmentVars(`value`: List<EciScalingConfigurationInitContainerEnvironmentVarArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVars = mapped
    }

    /**
     * @param argument The structure of environmentVars.
     * See `environment_vars` below for details.
     */
    @JvmName("aiamunfwlbchqelf")
    public suspend fun environmentVars(argument: List<suspend EciScalingConfigurationInitContainerEnvironmentVarArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationInitContainerEnvironmentVarArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVars = mapped
    }

    /**
     * @param argument The structure of environmentVars.
     * See `environment_vars` below for details.
     */
    @JvmName("ufdnggaupxrlbsji")
    public suspend fun environmentVars(vararg argument: suspend EciScalingConfigurationInitContainerEnvironmentVarArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationInitContainerEnvironmentVarArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVars = mapped
    }

    /**
     * @param argument The structure of environmentVars.
     * See `environment_vars` below for details.
     */
    @JvmName("vqulbysroiltufyj")
    public suspend fun environmentVars(argument: suspend EciScalingConfigurationInitContainerEnvironmentVarArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                EciScalingConfigurationInitContainerEnvironmentVarArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.environmentVars = mapped
    }

    /**
     * @param values The structure of environmentVars.
     * See `environment_vars` below for details.
     */
    @JvmName("tdjfhbvhxkyqitfr")
    public suspend fun environmentVars(vararg values: EciScalingConfigurationInitContainerEnvironmentVarArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVars = mapped
    }

    /**
     * @param value The number GPUs.
     */
    @JvmName("cibohwxcjfrybqnt")
    public suspend fun gpu(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gpu = mapped
    }

    /**
     * @param value The image of the container.
     */
    @JvmName("qfwdumexvehuffyc")
    public suspend fun image(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param value The restart policy of the image.
     */
    @JvmName("auiuvnmvypojcijc")
    public suspend fun imagePullPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imagePullPolicy = mapped
    }

    /**
     * @param value The amount of memory resources allocated to the container.
     */
    @JvmName("jnjgqtasbvgfgitj")
    public suspend fun memory(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memory = mapped
    }

    /**
     * @param value The name of the mounted volume.
     */
    @JvmName("gcpcwqpwfeddlupd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The structure of port. See `ports` below for details.
     */
    @JvmName("skfbqsubnnhyysfo")
    public suspend fun ports(`value`: List<EciScalingConfigurationInitContainerPortArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param argument The structure of port. See `ports` below for details.
     */
    @JvmName("qrbeqcgmkqoikohh")
    public suspend fun ports(argument: List<suspend EciScalingConfigurationInitContainerPortArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationInitContainerPortArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param argument The structure of port. See `ports` below for details.
     */
    @JvmName("meljhftwhfatxipy")
    public suspend fun ports(vararg argument: suspend EciScalingConfigurationInitContainerPortArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationInitContainerPortArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param argument The structure of port. See `ports` below for details.
     */
    @JvmName("pstxdrrbkvlomiqt")
    public suspend fun ports(argument: suspend EciScalingConfigurationInitContainerPortArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EciScalingConfigurationInitContainerPortArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param values The structure of port. See `ports` below for details.
     */
    @JvmName("grfwumckfuttolvi")
    public suspend fun ports(vararg values: EciScalingConfigurationInitContainerPortArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param value Grant certain permissions to processes within container. Optional values:
     * - NET_ADMIN: Allow network management tasks to be performed.
     * - NET_RAW: Allow raw sockets.
     */
    @JvmName("typkqhxsoccgdcrm")
    public suspend fun securityContextCapabilityAdds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityContextCapabilityAdds = mapped
    }

    /**
     * @param values Grant certain permissions to processes within container. Optional values:
     * - NET_ADMIN: Allow network management tasks to be performed.
     * - NET_RAW: Allow raw sockets.
     */
    @JvmName("xrxkgevgiiwjbatk")
    public suspend fun securityContextCapabilityAdds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityContextCapabilityAdds = mapped
    }

    /**
     * @param value Mounts the container's root filesystem as read-only.
     */
    @JvmName("pjxdamjqnupxafxy")
    public suspend fun securityContextReadOnlyRootFileSystem(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityContextReadOnlyRootFileSystem = mapped
    }

    /**
     * @param value Specifies user ID  under which all processes run.
     */
    @JvmName("gnewjpfbsrnskbkt")
    public suspend fun securityContextRunAsUser(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityContextRunAsUser = mapped
    }

    /**
     * @param value The structure of volumeMounts. See `volume_mounts` below for details.
     */
    @JvmName("kraouuosobupgqxo")
    public suspend fun volumeMounts(`value`: List<EciScalingConfigurationInitContainerVolumeMountArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    /**
     * @param argument The structure of volumeMounts. See `volume_mounts` below for details.
     */
    @JvmName("iikiiioxnplskvyw")
    public suspend fun volumeMounts(argument: List<suspend EciScalingConfigurationInitContainerVolumeMountArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationInitContainerVolumeMountArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument The structure of volumeMounts. See `volume_mounts` below for details.
     */
    @JvmName("hmyntssfuccfpaku")
    public suspend fun volumeMounts(vararg argument: suspend EciScalingConfigurationInitContainerVolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationInitContainerVolumeMountArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument The structure of volumeMounts. See `volume_mounts` below for details.
     */
    @JvmName("eyovjnipjtrmfuxb")
    public suspend fun volumeMounts(argument: suspend EciScalingConfigurationInitContainerVolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                EciScalingConfigurationInitContainerVolumeMountArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param values The structure of volumeMounts. See `volume_mounts` below for details.
     */
    @JvmName("ypvmxqawglburmiv")
    public suspend fun volumeMounts(vararg values: EciScalingConfigurationInitContainerVolumeMountArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    /**
     * @param value The working directory of the container.
     */
    @JvmName("osveadjkukgeffoy")
    public suspend fun workingDir(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workingDir = mapped
    }

    internal fun build(): EciScalingConfigurationInitContainerArgs =
        EciScalingConfigurationInitContainerArgs(
            args = args,
            commands = commands,
            cpu = cpu,
            environmentVars = environmentVars,
            gpu = gpu,
            image = image,
            imagePullPolicy = imagePullPolicy,
            memory = memory,
            name = name,
            ports = ports,
            securityContextCapabilityAdds = securityContextCapabilityAdds,
            securityContextReadOnlyRootFileSystem = securityContextReadOnlyRootFileSystem,
            securityContextRunAsUser = securityContextRunAsUser,
            volumeMounts = volumeMounts,
            workingDir = workingDir,
        )
}
