@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.inputs

import com.pulumi.alicloud.ess.inputs.EciScalingConfigurationInitContainerPortArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property port
 * @property protocol
 */
public data class EciScalingConfigurationInitContainerPortArgs(
    public val port: Output<Int>? = null,
    public val protocol: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.inputs.EciScalingConfigurationInitContainerPortArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.inputs.EciScalingConfigurationInitContainerPortArgs = com.pulumi.alicloud.ess.inputs.EciScalingConfigurationInitContainerPortArgs.builder()
        .port(port?.applyValue({ args0 -> args0 }))
        .protocol(protocol?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EciScalingConfigurationInitContainerPortArgs].
 */
@PulumiTagMarker
public class EciScalingConfigurationInitContainerPortArgsBuilder internal constructor() {
    private var port: Output<Int>? = null

    private var protocol: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("uhkqtmtixohisnwb")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value
     */
    @JvmName("sqavmjqdlpriekrg")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value
     */
    @JvmName("rxywiarcropmdruk")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value
     */
    @JvmName("ybremjfovreyjomk")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): EciScalingConfigurationInitContainerPortArgs =
        EciScalingConfigurationInitContainerPortArgs(
            port = port,
            protocol = protocol,
        )
}
