@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.inputs

import com.pulumi.alicloud.ess.inputs.EciScalingConfigurationInitContainerVolumeMountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mountPath
 * @property name
 * @property readOnly
 */
public data class EciScalingConfigurationInitContainerVolumeMountArgs(
    public val mountPath: Output<String>? = null,
    public val name: Output<String>? = null,
    public val readOnly: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.ess.inputs.EciScalingConfigurationInitContainerVolumeMountArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.inputs.EciScalingConfigurationInitContainerVolumeMountArgs =
        com.pulumi.alicloud.ess.inputs.EciScalingConfigurationInitContainerVolumeMountArgs.builder()
            .mountPath(mountPath?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .readOnly(readOnly?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EciScalingConfigurationInitContainerVolumeMountArgs].
 */
@PulumiTagMarker
public class EciScalingConfigurationInitContainerVolumeMountArgsBuilder internal constructor() {
    private var mountPath: Output<String>? = null

    private var name: Output<String>? = null

    private var readOnly: Output<Boolean>? = null

    /**
     * @param value
     */
    @JvmName("hjbtgnarerrbvfbo")
    public suspend fun mountPath(`value`: Output<String>) {
        this.mountPath = value
    }

    /**
     * @param value
     */
    @JvmName("lhnhrnspavqskiya")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("djmgxppfytmcppfa")
    public suspend fun readOnly(`value`: Output<Boolean>) {
        this.readOnly = value
    }

    /**
     * @param value
     */
    @JvmName("geprviriafvsxtso")
    public suspend fun mountPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountPath = mapped
    }

    /**
     * @param value
     */
    @JvmName("dohhvgduareupqjm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("cenxcnwlwoshlvht")
    public suspend fun readOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnly = mapped
    }

    internal fun build(): EciScalingConfigurationInitContainerVolumeMountArgs =
        EciScalingConfigurationInitContainerVolumeMountArgs(
            mountPath = mountPath,
            name = name,
            readOnly = readOnly,
        )
}
