@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.inputs

import com.pulumi.alicloud.ess.inputs.EciScalingConfigurationVolumeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property configFileVolumeConfigFileToPaths ConfigFileVolumeConfigFileToPaths.
 * See `config_file_volume_config_file_to_paths` below for details.
 * @property diskVolumeDiskId The ID of DiskVolume.
 * @property diskVolumeDiskSize The disk size of DiskVolume.
 * @property diskVolumeFsType The system type of DiskVolume.
 * @property flexVolumeDriver The name of the FlexVolume driver.
 * @property flexVolumeFsType The type of the mounted file system. The default value is determined by the script
 * of FlexVolume.
 * @property flexVolumeOptions The list of FlexVolume objects. Each object is a key-value pair contained in a JSON
 * string.
 * @property name The name of the volume.
 * @property nfsVolumePath The path to the NFS volume.
 * @property nfsVolumeReadOnly The nfs volume read only. Default to `false`.
 * @property nfsVolumeServer The address of the NFS server.
 * > **NOTE:** Every volume mounted must have a name and type attributes.
 * @property type The type of the volume.
 */
public data class EciScalingConfigurationVolumeArgs(
    public val configFileVolumeConfigFileToPaths: Output<List<EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgs>>? = null,
    public val diskVolumeDiskId: Output<String>? = null,
    public val diskVolumeDiskSize: Output<Int>? = null,
    public val diskVolumeFsType: Output<String>? = null,
    public val flexVolumeDriver: Output<String>? = null,
    public val flexVolumeFsType: Output<String>? = null,
    public val flexVolumeOptions: Output<String>? = null,
    public val name: Output<String>? = null,
    public val nfsVolumePath: Output<String>? = null,
    public val nfsVolumeReadOnly: Output<Boolean>? = null,
    public val nfsVolumeServer: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.inputs.EciScalingConfigurationVolumeArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.inputs.EciScalingConfigurationVolumeArgs =
        com.pulumi.alicloud.ess.inputs.EciScalingConfigurationVolumeArgs.builder()
            .configFileVolumeConfigFileToPaths(
                configFileVolumeConfigFileToPaths?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .diskVolumeDiskId(diskVolumeDiskId?.applyValue({ args0 -> args0 }))
            .diskVolumeDiskSize(diskVolumeDiskSize?.applyValue({ args0 -> args0 }))
            .diskVolumeFsType(diskVolumeFsType?.applyValue({ args0 -> args0 }))
            .flexVolumeDriver(flexVolumeDriver?.applyValue({ args0 -> args0 }))
            .flexVolumeFsType(flexVolumeFsType?.applyValue({ args0 -> args0 }))
            .flexVolumeOptions(flexVolumeOptions?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .nfsVolumePath(nfsVolumePath?.applyValue({ args0 -> args0 }))
            .nfsVolumeReadOnly(nfsVolumeReadOnly?.applyValue({ args0 -> args0 }))
            .nfsVolumeServer(nfsVolumeServer?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EciScalingConfigurationVolumeArgs].
 */
@PulumiTagMarker
public class EciScalingConfigurationVolumeArgsBuilder internal constructor() {
    private var configFileVolumeConfigFileToPaths:
        Output<List<EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgs>>? = null

    private var diskVolumeDiskId: Output<String>? = null

    private var diskVolumeDiskSize: Output<Int>? = null

    private var diskVolumeFsType: Output<String>? = null

    private var flexVolumeDriver: Output<String>? = null

    private var flexVolumeFsType: Output<String>? = null

    private var flexVolumeOptions: Output<String>? = null

    private var name: Output<String>? = null

    private var nfsVolumePath: Output<String>? = null

    private var nfsVolumeReadOnly: Output<Boolean>? = null

    private var nfsVolumeServer: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value ConfigFileVolumeConfigFileToPaths.
     * See `config_file_volume_config_file_to_paths` below for details.
     */
    @JvmName("lmthatgftfeomnrb")
    public suspend fun configFileVolumeConfigFileToPaths(`value`: Output<List<EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgs>>) {
        this.configFileVolumeConfigFileToPaths = value
    }

    @JvmName("ypnsmfyqmndllpnf")
    public suspend fun configFileVolumeConfigFileToPaths(vararg values: Output<EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgs>) {
        this.configFileVolumeConfigFileToPaths = Output.all(values.asList())
    }

    /**
     * @param values ConfigFileVolumeConfigFileToPaths.
     * See `config_file_volume_config_file_to_paths` below for details.
     */
    @JvmName("gwbductgqymoypib")
    public suspend fun configFileVolumeConfigFileToPaths(values: List<Output<EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgs>>) {
        this.configFileVolumeConfigFileToPaths = Output.all(values)
    }

    /**
     * @param value The ID of DiskVolume.
     */
    @JvmName("iekagujlprmudwoq")
    public suspend fun diskVolumeDiskId(`value`: Output<String>) {
        this.diskVolumeDiskId = value
    }

    /**
     * @param value The disk size of DiskVolume.
     */
    @JvmName("ceoramrrblrtmpkg")
    public suspend fun diskVolumeDiskSize(`value`: Output<Int>) {
        this.diskVolumeDiskSize = value
    }

    /**
     * @param value The system type of DiskVolume.
     */
    @JvmName("hlxefcsxrgbtdgpe")
    public suspend fun diskVolumeFsType(`value`: Output<String>) {
        this.diskVolumeFsType = value
    }

    /**
     * @param value The name of the FlexVolume driver.
     */
    @JvmName("jjaaogywvqoogtvx")
    public suspend fun flexVolumeDriver(`value`: Output<String>) {
        this.flexVolumeDriver = value
    }

    /**
     * @param value The type of the mounted file system. The default value is determined by the script
     * of FlexVolume.
     */
    @JvmName("pqgqiowgeghpxxtq")
    public suspend fun flexVolumeFsType(`value`: Output<String>) {
        this.flexVolumeFsType = value
    }

    /**
     * @param value The list of FlexVolume objects. Each object is a key-value pair contained in a JSON
     * string.
     */
    @JvmName("mruegsswryriudjf")
    public suspend fun flexVolumeOptions(`value`: Output<String>) {
        this.flexVolumeOptions = value
    }

    /**
     * @param value The name of the volume.
     */
    @JvmName("eujoawheqlfpgjcc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The path to the NFS volume.
     */
    @JvmName("osthgvlpoevicmyo")
    public suspend fun nfsVolumePath(`value`: Output<String>) {
        this.nfsVolumePath = value
    }

    /**
     * @param value The nfs volume read only. Default to `false`.
     */
    @JvmName("yvgkbnormmjyrugk")
    public suspend fun nfsVolumeReadOnly(`value`: Output<Boolean>) {
        this.nfsVolumeReadOnly = value
    }

    /**
     * @param value The address of the NFS server.
     * > **NOTE:** Every volume mounted must have a name and type attributes.
     */
    @JvmName("mcbwqdcqeuqeftxj")
    public suspend fun nfsVolumeServer(`value`: Output<String>) {
        this.nfsVolumeServer = value
    }

    /**
     * @param value The type of the volume.
     */
    @JvmName("ugpjsloqtrafeawg")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value ConfigFileVolumeConfigFileToPaths.
     * See `config_file_volume_config_file_to_paths` below for details.
     */
    @JvmName("cwtfsaykxykuhvos")
    public suspend fun configFileVolumeConfigFileToPaths(`value`: List<EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configFileVolumeConfigFileToPaths = mapped
    }

    /**
     * @param argument ConfigFileVolumeConfigFileToPaths.
     * See `config_file_volume_config_file_to_paths` below for details.
     */
    @JvmName("ebwxsvfmistdueyl")
    public suspend fun configFileVolumeConfigFileToPaths(argument: List<suspend EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configFileVolumeConfigFileToPaths = mapped
    }

    /**
     * @param argument ConfigFileVolumeConfigFileToPaths.
     * See `config_file_volume_config_file_to_paths` below for details.
     */
    @JvmName("fjnyswlamvclffbl")
    public suspend fun configFileVolumeConfigFileToPaths(vararg argument: suspend EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configFileVolumeConfigFileToPaths = mapped
    }

    /**
     * @param argument ConfigFileVolumeConfigFileToPaths.
     * See `config_file_volume_config_file_to_paths` below for details.
     */
    @JvmName("dpnrgoqttphykrww")
    public suspend fun configFileVolumeConfigFileToPaths(argument: suspend EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.configFileVolumeConfigFileToPaths = mapped
    }

    /**
     * @param values ConfigFileVolumeConfigFileToPaths.
     * See `config_file_volume_config_file_to_paths` below for details.
     */
    @JvmName("rdjimhjyhkeexeaj")
    public suspend fun configFileVolumeConfigFileToPaths(vararg values: EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configFileVolumeConfigFileToPaths = mapped
    }

    /**
     * @param value The ID of DiskVolume.
     */
    @JvmName("kgcqgqgxdqivrpll")
    public suspend fun diskVolumeDiskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskVolumeDiskId = mapped
    }

    /**
     * @param value The disk size of DiskVolume.
     */
    @JvmName("mwmusrxhhhckbuor")
    public suspend fun diskVolumeDiskSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskVolumeDiskSize = mapped
    }

    /**
     * @param value The system type of DiskVolume.
     */
    @JvmName("wjbsbvrprfftrfiy")
    public suspend fun diskVolumeFsType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskVolumeFsType = mapped
    }

    /**
     * @param value The name of the FlexVolume driver.
     */
    @JvmName("sbpmuuquxkjanlpl")
    public suspend fun flexVolumeDriver(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flexVolumeDriver = mapped
    }

    /**
     * @param value The type of the mounted file system. The default value is determined by the script
     * of FlexVolume.
     */
    @JvmName("itmaggseeyhaqvug")
    public suspend fun flexVolumeFsType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flexVolumeFsType = mapped
    }

    /**
     * @param value The list of FlexVolume objects. Each object is a key-value pair contained in a JSON
     * string.
     */
    @JvmName("edpjncjlqgrymsjo")
    public suspend fun flexVolumeOptions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flexVolumeOptions = mapped
    }

    /**
     * @param value The name of the volume.
     */
    @JvmName("byrcnjpijovmmppp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The path to the NFS volume.
     */
    @JvmName("faviuhcldpvkwhvo")
    public suspend fun nfsVolumePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nfsVolumePath = mapped
    }

    /**
     * @param value The nfs volume read only. Default to `false`.
     */
    @JvmName("djbwtuirubaixdxc")
    public suspend fun nfsVolumeReadOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nfsVolumeReadOnly = mapped
    }

    /**
     * @param value The address of the NFS server.
     * > **NOTE:** Every volume mounted must have a name and type attributes.
     */
    @JvmName("fommtwcuklqegjar")
    public suspend fun nfsVolumeServer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nfsVolumeServer = mapped
    }

    /**
     * @param value The type of the volume.
     */
    @JvmName("ipcatoknrtmfbyhv")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): EciScalingConfigurationVolumeArgs = EciScalingConfigurationVolumeArgs(
        configFileVolumeConfigFileToPaths = configFileVolumeConfigFileToPaths,
        diskVolumeDiskId = diskVolumeDiskId,
        diskVolumeDiskSize = diskVolumeDiskSize,
        diskVolumeFsType = diskVolumeFsType,
        flexVolumeDriver = flexVolumeDriver,
        flexVolumeFsType = flexVolumeFsType,
        flexVolumeOptions = flexVolumeOptions,
        name = name,
        nfsVolumePath = nfsVolumePath,
        nfsVolumeReadOnly = nfsVolumeReadOnly,
        nfsVolumeServer = nfsVolumeServer,
        type = type,
    )
}
