@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.inputs

import com.pulumi.alicloud.ess.inputs.EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property content The content of the configuration file. Maximum size: 32 KB.
 * @property path The relative file path.
 */
public data class EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgs(
    public val content: Output<String>? = null,
    public val path: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.ess.inputs.EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.inputs.EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgs =
        com.pulumi.alicloud.ess.inputs.EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgs.builder()
            .content(content?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgs].
 */
@PulumiTagMarker
public class EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var path: Output<String>? = null

    /**
     * @param value The content of the configuration file. Maximum size: 32 KB.
     */
    @JvmName("ltkcjxvjitojhgeh")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The relative file path.
     */
    @JvmName("ctfdranoeuxoertu")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The content of the configuration file. Maximum size: 32 KB.
     */
    @JvmName("mrhicuwjwtitxfql")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The relative file path.
     */
    @JvmName("pojeqdtqquctddry")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgs =
        EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgs(
            content = content,
            path = path,
        )
}
