@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.inputs

import com.pulumi.alicloud.ess.inputs.GetAlarmsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAlarms.
 * @property ids A list of alarm IDs.
 * @property metricType The type for the alarm's associated metric. Supported value: system, custom. "system" means the metric data is collected by Aliyun Cloud Monitor Service(CMS), "custom" means the metric data is upload to CMS by users. Defaults to system.
 * @property nameRegex A regex string to filter resulting alarms by name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property scalingGroupId Scaling group id the alarms belong to.
 */
public data class GetAlarmsPlainArgs(
    public val ids: List<String>? = null,
    public val metricType: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val scalingGroupId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.inputs.GetAlarmsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.inputs.GetAlarmsPlainArgs =
        com.pulumi.alicloud.ess.inputs.GetAlarmsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .metricType(metricType?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .scalingGroupId(scalingGroupId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAlarmsPlainArgs].
 */
@PulumiTagMarker
public class GetAlarmsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var metricType: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var scalingGroupId: String? = null

    /**
     * @param value A list of alarm IDs.
     */
    @JvmName("recexvxprrrxsfkw")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of alarm IDs.
     */
    @JvmName("lhtkmjhckthlkprw")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The type for the alarm's associated metric. Supported value: system, custom. "system" means the metric data is collected by Aliyun Cloud Monitor Service(CMS), "custom" means the metric data is upload to CMS by users. Defaults to system.
     */
    @JvmName("esrvgwobhygdpobb")
    public suspend fun metricType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.metricType = mapped
    }

    /**
     * @param value A regex string to filter resulting alarms by name.
     */
    @JvmName("cyvkccwkdhahhmxr")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("tungoppmjlcsgvbs")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Scaling group id the alarms belong to.
     */
    @JvmName("jwyicviseejmnboq")
    public suspend fun scalingGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.scalingGroupId = mapped
    }

    internal fun build(): GetAlarmsPlainArgs = GetAlarmsPlainArgs(
        ids = ids,
        metricType = metricType,
        nameRegex = nameRegex,
        outputFile = outputFile,
        scalingGroupId = scalingGroupId,
    )
}
