@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.inputs

import com.pulumi.alicloud.ess.inputs.GetNotificationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getNotifications.
 * @property ids A list of notification ids.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property scalingGroupId Scaling group id the notifications belong to.
 */
public data class GetNotificationsPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val scalingGroupId: String,
) : ConvertibleToJava<com.pulumi.alicloud.ess.inputs.GetNotificationsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.inputs.GetNotificationsPlainArgs =
        com.pulumi.alicloud.ess.inputs.GetNotificationsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .scalingGroupId(scalingGroupId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNotificationsPlainArgs].
 */
@PulumiTagMarker
public class GetNotificationsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var scalingGroupId: String? = null

    /**
     * @param value A list of notification ids.
     */
    @JvmName("gvpelksuxftfqflk")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of notification ids.
     */
    @JvmName("xdisidbendldxfja")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("xtkjtfvhoufybdvw")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Scaling group id the notifications belong to.
     */
    @JvmName("jwvynumtlkkpihgf")
    public suspend fun scalingGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scalingGroupId = mapped
    }

    internal fun build(): GetNotificationsPlainArgs = GetNotificationsPlainArgs(
        ids = ids,
        outputFile = outputFile,
        scalingGroupId = scalingGroupId ?: throw PulumiNullFieldException("scalingGroupId"),
    )
}
