@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.inputs

import com.pulumi.alicloud.ess.inputs.GetScalingConfigurationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getScalingConfigurations.
 * @property ids A list of scaling configuration IDs.
 * @property nameRegex A regex string to filter resulting scaling configurations by name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property scalingGroupId Scaling group id the scaling configurations belong to.
 */
public data class GetScalingConfigurationsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val scalingGroupId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.inputs.GetScalingConfigurationsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.inputs.GetScalingConfigurationsPlainArgs =
        com.pulumi.alicloud.ess.inputs.GetScalingConfigurationsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .scalingGroupId(scalingGroupId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetScalingConfigurationsPlainArgs].
 */
@PulumiTagMarker
public class GetScalingConfigurationsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var scalingGroupId: String? = null

    /**
     * @param value A list of scaling configuration IDs.
     */
    @JvmName("ptquhvppapoomlvy")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of scaling configuration IDs.
     */
    @JvmName("yanmmlvgdbgrgucc")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter resulting scaling configurations by name.
     */
    @JvmName("radjtxnsnsvrakha")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("lepdbkhahqmxyfca")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Scaling group id the scaling configurations belong to.
     */
    @JvmName("wuspcitcthhweuav")
    public suspend fun scalingGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.scalingGroupId = mapped
    }

    internal fun build(): GetScalingConfigurationsPlainArgs = GetScalingConfigurationsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        scalingGroupId = scalingGroupId,
    )
}
