@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.inputs

import com.pulumi.alicloud.ess.inputs.GetScalingRulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getScalingRules.
 * @property ids A list of scaling rule IDs.
 * @property nameRegex A regex string to filter resulting scaling rules by name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property scalingGroupId Scaling group id the scaling rules belong to.
 * @property type Type of scaling rule.
 */
public data class GetScalingRulesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val scalingGroupId: String? = null,
    public val type: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.inputs.GetScalingRulesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.inputs.GetScalingRulesPlainArgs =
        com.pulumi.alicloud.ess.inputs.GetScalingRulesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .scalingGroupId(scalingGroupId?.let({ args0 -> args0 }))
            .type(type?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetScalingRulesPlainArgs].
 */
@PulumiTagMarker
public class GetScalingRulesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var scalingGroupId: String? = null

    private var type: String? = null

    /**
     * @param value A list of scaling rule IDs.
     */
    @JvmName("hxxleuntiseflfts")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of scaling rule IDs.
     */
    @JvmName("wcryispvubkyqejp")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter resulting scaling rules by name.
     */
    @JvmName("syuvxaruvkhgfxed")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("wafnjxophdejatmb")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Scaling group id the scaling rules belong to.
     */
    @JvmName("nkjnmrhonfuqrjbs")
    public suspend fun scalingGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.scalingGroupId = mapped
    }

    /**
     * @param value Type of scaling rule.
     */
    @JvmName("fpmddupmsbfhrcwe")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetScalingRulesPlainArgs = GetScalingRulesPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        scalingGroupId = scalingGroupId,
        type = type,
    )
}
