@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.inputs

import com.pulumi.alicloud.ess.inputs.GetScheduledTasksPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getScheduledTasks.
 * @property ids A list of scheduled task IDs.
 * @property nameRegex A regex string to filter resulting scheduled tasks by name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property scheduledAction The operation to be performed when a scheduled task is triggered.
 * @property scheduledTaskId The id of the scheduled task.
 */
public data class GetScheduledTasksPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val scheduledAction: String? = null,
    public val scheduledTaskId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.inputs.GetScheduledTasksPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.inputs.GetScheduledTasksPlainArgs =
        com.pulumi.alicloud.ess.inputs.GetScheduledTasksPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .scheduledAction(scheduledAction?.let({ args0 -> args0 }))
            .scheduledTaskId(scheduledTaskId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetScheduledTasksPlainArgs].
 */
@PulumiTagMarker
public class GetScheduledTasksPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var scheduledAction: String? = null

    private var scheduledTaskId: String? = null

    /**
     * @param value A list of scheduled task IDs.
     */
    @JvmName("msneyidmmtnkjkyb")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of scheduled task IDs.
     */
    @JvmName("oxnavhbpkjimpkxc")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter resulting scheduled tasks by name.
     */
    @JvmName("srcgmjtffmyrfxso")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("gwwhfnqcitgrrbud")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The operation to be performed when a scheduled task is triggered.
     */
    @JvmName("bmsbevdxarvrgerj")
    public suspend fun scheduledAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.scheduledAction = mapped
    }

    /**
     * @param value The id of the scheduled task.
     */
    @JvmName("olrgrbnyidlhfogl")
    public suspend fun scheduledTaskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.scheduledTaskId = mapped
    }

    internal fun build(): GetScheduledTasksPlainArgs = GetScheduledTasksPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        scheduledAction = scheduledAction,
        scheduledTaskId = scheduledTaskId,
    )
}
