@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.inputs

import com.pulumi.alicloud.ess.inputs.ScalingConfigurationDataDiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property autoSnapshotPolicyId The id of auto snapshot policy for data disk.
 * @property category Category of data disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd` , `cloud_essd` and `cloud`.
 * @property deleteWithInstance Whether to delete data disks attached on ecs when release ecs instance. Optional value: `true` or `false`, default to `true`.
 * @property description The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
 * @property device The mount point of data disk N. Valid values of N: 1 to 16. If this parameter is not specified, the system automatically allocates a mount point to created ECS instances. The name of the mount point ranges from /dev/xvdb to /dev/xvdz in alphabetical order.
 * @property encrypted Specifies whether data disk N is to be encrypted. Valid values of N: 1 to 16. Valid values: `true`: encrypted, `false`: not encrypted. Default value: `false`.
 * @property kmsKeyId The CMK ID for data disk N. Valid values of N: 1 to 16.
 * @property name The name of data disk N. Valid values of N: 1 to 16. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
 * @property performanceLevel The performance level of the ESSD used as data disk.
 * @property size Size of data disk, in GB. The value ranges [5,2000] for a cloud disk, [5,1024] for an ephemeral disk, [5,800] for an ephemeral_ssd disk, [20,32768] for cloud_efficiency, cloud_ssd, cloud_essd disk.
 * @property snapshotId Snapshot used for creating the data disk. If this parameter is specified, the size parameter is neglected, and the size of the created disk is the size of the snapshot.
 */
public data class ScalingConfigurationDataDiskArgs(
    public val autoSnapshotPolicyId: Output<String>? = null,
    public val category: Output<String>? = null,
    public val deleteWithInstance: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    @Deprecated(
        message = """
  Attribute device has been deprecated on disk attachment resource. Suggest to remove it from your
      template.
  """,
    )
    public val device: Output<String>? = null,
    public val encrypted: Output<Boolean>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val performanceLevel: Output<String>? = null,
    public val size: Output<Int>? = null,
    public val snapshotId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.inputs.ScalingConfigurationDataDiskArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.inputs.ScalingConfigurationDataDiskArgs =
        com.pulumi.alicloud.ess.inputs.ScalingConfigurationDataDiskArgs.builder()
            .autoSnapshotPolicyId(autoSnapshotPolicyId?.applyValue({ args0 -> args0 }))
            .category(category?.applyValue({ args0 -> args0 }))
            .deleteWithInstance(deleteWithInstance?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .device(device?.applyValue({ args0 -> args0 }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .performanceLevel(performanceLevel?.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScalingConfigurationDataDiskArgs].
 */
@PulumiTagMarker
public class ScalingConfigurationDataDiskArgsBuilder internal constructor() {
    private var autoSnapshotPolicyId: Output<String>? = null

    private var category: Output<String>? = null

    private var deleteWithInstance: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var device: Output<String>? = null

    private var encrypted: Output<Boolean>? = null

    private var kmsKeyId: Output<String>? = null

    private var name: Output<String>? = null

    private var performanceLevel: Output<String>? = null

    private var size: Output<Int>? = null

    private var snapshotId: Output<String>? = null

    /**
     * @param value The id of auto snapshot policy for data disk.
     */
    @JvmName("mqrounfiafjymvda")
    public suspend fun autoSnapshotPolicyId(`value`: Output<String>) {
        this.autoSnapshotPolicyId = value
    }

    /**
     * @param value Category of data disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd` , `cloud_essd` and `cloud`.
     */
    @JvmName("uxfekmfwreuhcwdf")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value Whether to delete data disks attached on ecs when release ecs instance. Optional value: `true` or `false`, default to `true`.
     */
    @JvmName("unqndhkdjlifnwjr")
    public suspend fun deleteWithInstance(`value`: Output<Boolean>) {
        this.deleteWithInstance = value
    }

    /**
     * @param value The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
     */
    @JvmName("orniloykiyvkluej")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The mount point of data disk N. Valid values of N: 1 to 16. If this parameter is not specified, the system automatically allocates a mount point to created ECS instances. The name of the mount point ranges from /dev/xvdb to /dev/xvdz in alphabetical order.
     */
    @Deprecated(
        message = """
  Attribute device has been deprecated on disk attachment resource. Suggest to remove it from your
      template.
  """,
    )
    @JvmName("qbrfbbgfdvfvossu")
    public suspend fun device(`value`: Output<String>) {
        this.device = value
    }

    /**
     * @param value Specifies whether data disk N is to be encrypted. Valid values of N: 1 to 16. Valid values: `true`: encrypted, `false`: not encrypted. Default value: `false`.
     */
    @JvmName("btodpwlqmxqlqyqt")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value The CMK ID for data disk N. Valid values of N: 1 to 16.
     */
    @JvmName("fqqjexgquwgykgab")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The name of data disk N. Valid values of N: 1 to 16. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
     */
    @JvmName("bxbhvpbuavikgaxt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The performance level of the ESSD used as data disk.
     */
    @JvmName("rbofbrlhmyoojdqf")
    public suspend fun performanceLevel(`value`: Output<String>) {
        this.performanceLevel = value
    }

    /**
     * @param value Size of data disk, in GB. The value ranges [5,2000] for a cloud disk, [5,1024] for an ephemeral disk, [5,800] for an ephemeral_ssd disk, [20,32768] for cloud_efficiency, cloud_ssd, cloud_essd disk.
     */
    @JvmName("pxgkwsoaucseyyuk")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value Snapshot used for creating the data disk. If this parameter is specified, the size parameter is neglected, and the size of the created disk is the size of the snapshot.
     */
    @JvmName("juicedvjcomdkjfq")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value The id of auto snapshot policy for data disk.
     */
    @JvmName("btfdwdjdqdcnsrpa")
    public suspend fun autoSnapshotPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoSnapshotPolicyId = mapped
    }

    /**
     * @param value Category of data disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd` , `cloud_essd` and `cloud`.
     */
    @JvmName("kcnmvxyywhttpfir")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Whether to delete data disks attached on ecs when release ecs instance. Optional value: `true` or `false`, default to `true`.
     */
    @JvmName("uduhvkrmscchjyja")
    public suspend fun deleteWithInstance(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteWithInstance = mapped
    }

    /**
     * @param value The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
     */
    @JvmName("nrskumtpayllcakb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The mount point of data disk N. Valid values of N: 1 to 16. If this parameter is not specified, the system automatically allocates a mount point to created ECS instances. The name of the mount point ranges from /dev/xvdb to /dev/xvdz in alphabetical order.
     */
    @Deprecated(
        message = """
  Attribute device has been deprecated on disk attachment resource. Suggest to remove it from your
      template.
  """,
    )
    @JvmName("aoorceccbtllyxns")
    public suspend fun device(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.device = mapped
    }

    /**
     * @param value Specifies whether data disk N is to be encrypted. Valid values of N: 1 to 16. Valid values: `true`: encrypted, `false`: not encrypted. Default value: `false`.
     */
    @JvmName("oegvwqwevrqgrgnl")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value The CMK ID for data disk N. Valid values of N: 1 to 16.
     */
    @JvmName("rtcuwpguodcykrjw")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The name of data disk N. Valid values of N: 1 to 16. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
     */
    @JvmName("gojbpkhifgfawgwm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The performance level of the ESSD used as data disk.
     */
    @JvmName("ntrateptqyckykxa")
    public suspend fun performanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performanceLevel = mapped
    }

    /**
     * @param value Size of data disk, in GB. The value ranges [5,2000] for a cloud disk, [5,1024] for an ephemeral disk, [5,800] for an ephemeral_ssd disk, [20,32768] for cloud_efficiency, cloud_ssd, cloud_essd disk.
     */
    @JvmName("kmdgmjdmgqlhxdiu")
    public suspend fun size(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value Snapshot used for creating the data disk. If this parameter is specified, the size parameter is neglected, and the size of the created disk is the size of the snapshot.
     */
    @JvmName("ppdtovnunqagoiqd")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    internal fun build(): ScalingConfigurationDataDiskArgs = ScalingConfigurationDataDiskArgs(
        autoSnapshotPolicyId = autoSnapshotPolicyId,
        category = category,
        deleteWithInstance = deleteWithInstance,
        description = description,
        device = device,
        encrypted = encrypted,
        kmsKeyId = kmsKeyId,
        name = name,
        performanceLevel = performanceLevel,
        size = size,
        snapshotId = snapshotId,
    )
}
