@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.inputs

import com.pulumi.alicloud.ess.inputs.ScalingConfigurationInstancePatternInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property architectures Architecture N of instance type N. Valid values: X86, Heterogeneous, BareMetal, Arm, SuperComputeCluster.
 * @property burstablePerformance Specifies whether to include burstable instance types.  Valid values: Exclude, Include, Required.
 * @property cores The number of vCPUs that are specified for an instance type in instancePatternInfo.
 * @property excludedInstanceTypes Instance type N that you want to exclude. You can use wildcard characters, such as an asterisk (*), to exclude an instance type or an instance family.
 * @property instanceFamilyLevel The instance family level in instancePatternInfo.
 * @property maxPrice The maximum hourly price for a pay-as-you-go instance or a preemptible instance in instancePatternInfo.
 * @property memory The memory size that is specified for an instance type in instancePatternInfo.
 */
public data class ScalingConfigurationInstancePatternInfoArgs(
    public val architectures: Output<List<String>>? = null,
    public val burstablePerformance: Output<String>? = null,
    public val cores: Output<Int>? = null,
    public val excludedInstanceTypes: Output<List<String>>? = null,
    public val instanceFamilyLevel: Output<String>? = null,
    public val maxPrice: Output<Double>? = null,
    public val memory: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.inputs.ScalingConfigurationInstancePatternInfoArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.inputs.ScalingConfigurationInstancePatternInfoArgs = com.pulumi.alicloud.ess.inputs.ScalingConfigurationInstancePatternInfoArgs.builder()
        .architectures(architectures?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .burstablePerformance(burstablePerformance?.applyValue({ args0 -> args0 }))
        .cores(cores?.applyValue({ args0 -> args0 }))
        .excludedInstanceTypes(excludedInstanceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .instanceFamilyLevel(instanceFamilyLevel?.applyValue({ args0 -> args0 }))
        .maxPrice(maxPrice?.applyValue({ args0 -> args0 }))
        .memory(memory?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScalingConfigurationInstancePatternInfoArgs].
 */
@PulumiTagMarker
public class ScalingConfigurationInstancePatternInfoArgsBuilder internal constructor() {
    private var architectures: Output<List<String>>? = null

    private var burstablePerformance: Output<String>? = null

    private var cores: Output<Int>? = null

    private var excludedInstanceTypes: Output<List<String>>? = null

    private var instanceFamilyLevel: Output<String>? = null

    private var maxPrice: Output<Double>? = null

    private var memory: Output<Double>? = null

    /**
     * @param value Architecture N of instance type N. Valid values: X86, Heterogeneous, BareMetal, Arm, SuperComputeCluster.
     */
    @JvmName("cxkewtjlqtuvjmfh")
    public suspend fun architectures(`value`: Output<List<String>>) {
        this.architectures = value
    }

    @JvmName("kpwtdxnhalomotey")
    public suspend fun architectures(vararg values: Output<String>) {
        this.architectures = Output.all(values.asList())
    }

    /**
     * @param values Architecture N of instance type N. Valid values: X86, Heterogeneous, BareMetal, Arm, SuperComputeCluster.
     */
    @JvmName("vbulxannjsefehim")
    public suspend fun architectures(values: List<Output<String>>) {
        this.architectures = Output.all(values)
    }

    /**
     * @param value Specifies whether to include burstable instance types.  Valid values: Exclude, Include, Required.
     */
    @JvmName("xwnsjglqnsykjgbv")
    public suspend fun burstablePerformance(`value`: Output<String>) {
        this.burstablePerformance = value
    }

    /**
     * @param value The number of vCPUs that are specified for an instance type in instancePatternInfo.
     */
    @JvmName("jmqkgnsdptywtgpp")
    public suspend fun cores(`value`: Output<Int>) {
        this.cores = value
    }

    /**
     * @param value Instance type N that you want to exclude. You can use wildcard characters, such as an asterisk (*), to exclude an instance type or an instance family.
     */
    @JvmName("scbilhayjsyvoutl")
    public suspend fun excludedInstanceTypes(`value`: Output<List<String>>) {
        this.excludedInstanceTypes = value
    }

    @JvmName("xvngphecjrbvnciq")
    public suspend fun excludedInstanceTypes(vararg values: Output<String>) {
        this.excludedInstanceTypes = Output.all(values.asList())
    }

    /**
     * @param values Instance type N that you want to exclude. You can use wildcard characters, such as an asterisk (*), to exclude an instance type or an instance family.
     */
    @JvmName("pkmswodocgyeubqe")
    public suspend fun excludedInstanceTypes(values: List<Output<String>>) {
        this.excludedInstanceTypes = Output.all(values)
    }

    /**
     * @param value The instance family level in instancePatternInfo.
     */
    @JvmName("mxkavwcsrjkhwtef")
    public suspend fun instanceFamilyLevel(`value`: Output<String>) {
        this.instanceFamilyLevel = value
    }

    /**
     * @param value The maximum hourly price for a pay-as-you-go instance or a preemptible instance in instancePatternInfo.
     */
    @JvmName("paxoxrpskofvefoa")
    public suspend fun maxPrice(`value`: Output<Double>) {
        this.maxPrice = value
    }

    /**
     * @param value The memory size that is specified for an instance type in instancePatternInfo.
     */
    @JvmName("niafolnagrvetkhv")
    public suspend fun memory(`value`: Output<Double>) {
        this.memory = value
    }

    /**
     * @param value Architecture N of instance type N. Valid values: X86, Heterogeneous, BareMetal, Arm, SuperComputeCluster.
     */
    @JvmName("mqrtxirimsybrrbj")
    public suspend fun architectures(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.architectures = mapped
    }

    /**
     * @param values Architecture N of instance type N. Valid values: X86, Heterogeneous, BareMetal, Arm, SuperComputeCluster.
     */
    @JvmName("jlmjgvnjqoyljdle")
    public suspend fun architectures(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.architectures = mapped
    }

    /**
     * @param value Specifies whether to include burstable instance types.  Valid values: Exclude, Include, Required.
     */
    @JvmName("fbxmviuomjgyjlmg")
    public suspend fun burstablePerformance(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.burstablePerformance = mapped
    }

    /**
     * @param value The number of vCPUs that are specified for an instance type in instancePatternInfo.
     */
    @JvmName("nfbavbguftnyiwli")
    public suspend fun cores(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cores = mapped
    }

    /**
     * @param value Instance type N that you want to exclude. You can use wildcard characters, such as an asterisk (*), to exclude an instance type or an instance family.
     */
    @JvmName("enfdqsyfcvtfpodl")
    public suspend fun excludedInstanceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedInstanceTypes = mapped
    }

    /**
     * @param values Instance type N that you want to exclude. You can use wildcard characters, such as an asterisk (*), to exclude an instance type or an instance family.
     */
    @JvmName("moggmdknmstkrtdy")
    public suspend fun excludedInstanceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedInstanceTypes = mapped
    }

    /**
     * @param value The instance family level in instancePatternInfo.
     */
    @JvmName("gxvklurksjqparfa")
    public suspend fun instanceFamilyLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceFamilyLevel = mapped
    }

    /**
     * @param value The maximum hourly price for a pay-as-you-go instance or a preemptible instance in instancePatternInfo.
     */
    @JvmName("txcwfooiyunjclaj")
    public suspend fun maxPrice(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxPrice = mapped
    }

    /**
     * @param value The memory size that is specified for an instance type in instancePatternInfo.
     */
    @JvmName("kgxekofjnjnhkhol")
    public suspend fun memory(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memory = mapped
    }

    internal fun build(): ScalingConfigurationInstancePatternInfoArgs =
        ScalingConfigurationInstancePatternInfoArgs(
            architectures = architectures,
            burstablePerformance = burstablePerformance,
            cores = cores,
            excludedInstanceTypes = excludedInstanceTypes,
            instanceFamilyLevel = instanceFamilyLevel,
            maxPrice = maxPrice,
            memory = memory,
        )
}
