@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.inputs

import com.pulumi.alicloud.ess.inputs.ScalingConfigurationInstanceTypeOverrideArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instanceType The is specified for an instance type in instanceTypeOverride.
 * @property weightedCapacity The weight of instance type in instanceTypeOverride.
 */
public data class ScalingConfigurationInstanceTypeOverrideArgs(
    public val instanceType: Output<String>? = null,
    public val weightedCapacity: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.inputs.ScalingConfigurationInstanceTypeOverrideArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.inputs.ScalingConfigurationInstanceTypeOverrideArgs = com.pulumi.alicloud.ess.inputs.ScalingConfigurationInstanceTypeOverrideArgs.builder()
        .instanceType(instanceType?.applyValue({ args0 -> args0 }))
        .weightedCapacity(weightedCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScalingConfigurationInstanceTypeOverrideArgs].
 */
@PulumiTagMarker
public class ScalingConfigurationInstanceTypeOverrideArgsBuilder internal constructor() {
    private var instanceType: Output<String>? = null

    private var weightedCapacity: Output<Int>? = null

    /**
     * @param value The is specified for an instance type in instanceTypeOverride.
     */
    @JvmName("qqrifqyrvdusduqp")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The weight of instance type in instanceTypeOverride.
     */
    @JvmName("yykruvlgggwoqbbq")
    public suspend fun weightedCapacity(`value`: Output<Int>) {
        this.weightedCapacity = value
    }

    /**
     * @param value The is specified for an instance type in instanceTypeOverride.
     */
    @JvmName("hobrrvcbuhdpwbbv")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The weight of instance type in instanceTypeOverride.
     */
    @JvmName("sxjjcnotjbdkxlgu")
    public suspend fun weightedCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weightedCapacity = mapped
    }

    internal fun build(): ScalingConfigurationInstanceTypeOverrideArgs =
        ScalingConfigurationInstanceTypeOverrideArgs(
            instanceType = instanceType,
            weightedCapacity = weightedCapacity,
        )
}
