@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.inputs

import com.pulumi.alicloud.ess.inputs.ScalingConfigurationSpotPriceLimitArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instanceType Resource type of an ECS instance.
 * @property priceLimit Price limit hourly of instance type, 2 decimals is allowed at most.
 */
public data class ScalingConfigurationSpotPriceLimitArgs(
    public val instanceType: Output<String>? = null,
    public val priceLimit: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.inputs.ScalingConfigurationSpotPriceLimitArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.inputs.ScalingConfigurationSpotPriceLimitArgs =
        com.pulumi.alicloud.ess.inputs.ScalingConfigurationSpotPriceLimitArgs.builder()
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .priceLimit(priceLimit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScalingConfigurationSpotPriceLimitArgs].
 */
@PulumiTagMarker
public class ScalingConfigurationSpotPriceLimitArgsBuilder internal constructor() {
    private var instanceType: Output<String>? = null

    private var priceLimit: Output<Double>? = null

    /**
     * @param value Resource type of an ECS instance.
     */
    @JvmName("lodxyjkspmlucpnw")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Price limit hourly of instance type, 2 decimals is allowed at most.
     */
    @JvmName("jhbvsmockxklijju")
    public suspend fun priceLimit(`value`: Output<Double>) {
        this.priceLimit = value
    }

    /**
     * @param value Resource type of an ECS instance.
     */
    @JvmName("taycyqfkurjoplfg")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Price limit hourly of instance type, 2 decimals is allowed at most.
     */
    @JvmName("rrnonoljuqotmbjr")
    public suspend fun priceLimit(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priceLimit = mapped
    }

    internal fun build(): ScalingConfigurationSpotPriceLimitArgs =
        ScalingConfigurationSpotPriceLimitArgs(
            instanceType = instanceType,
            priceLimit = priceLimit,
        )
}
