@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.inputs

import com.pulumi.alicloud.ess.inputs.ScalingGroupAlbServerGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property albServerGroupId The ID of ALB server group.
 * @property port The port number used by an ECS instance after Auto Scaling adds the ECS instance to ALB server group.
 * @property weight The weight of the ECS instance as a backend server after Auto Scaling adds the ECS instance to ALB server group.
 */
public data class ScalingGroupAlbServerGroupArgs(
    public val albServerGroupId: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val weight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.inputs.ScalingGroupAlbServerGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.inputs.ScalingGroupAlbServerGroupArgs =
        com.pulumi.alicloud.ess.inputs.ScalingGroupAlbServerGroupArgs.builder()
            .albServerGroupId(albServerGroupId?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScalingGroupAlbServerGroupArgs].
 */
@PulumiTagMarker
public class ScalingGroupAlbServerGroupArgsBuilder internal constructor() {
    private var albServerGroupId: Output<String>? = null

    private var port: Output<Int>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value The ID of ALB server group.
     */
    @JvmName("qmameckdctgoiklw")
    public suspend fun albServerGroupId(`value`: Output<String>) {
        this.albServerGroupId = value
    }

    /**
     * @param value The port number used by an ECS instance after Auto Scaling adds the ECS instance to ALB server group.
     */
    @JvmName("agonjhscgkecdlqq")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The weight of the ECS instance as a backend server after Auto Scaling adds the ECS instance to ALB server group.
     */
    @JvmName("nebgymcvecuuurlr")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value The ID of ALB server group.
     */
    @JvmName("xoqpbbufhgamgifv")
    public suspend fun albServerGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.albServerGroupId = mapped
    }

    /**
     * @param value The port number used by an ECS instance after Auto Scaling adds the ECS instance to ALB server group.
     */
    @JvmName("heygevkaxsucirtt")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The weight of the ECS instance as a backend server after Auto Scaling adds the ECS instance to ALB server group.
     */
    @JvmName("ffniipjxgusqujtg")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): ScalingGroupAlbServerGroupArgs = ScalingGroupAlbServerGroupArgs(
        albServerGroupId = albServerGroupId,
        port = port,
        weight = weight,
    )
}
