@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.inputs

import com.pulumi.alicloud.ess.inputs.ScalingGroupLaunchTemplateOverrideArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instanceType The instance type in launchTemplateOverride.
 * @property spotPriceLimit The maximum bid price of instance type in launchTemplateOverride.
 * > **NOTE:** When detach loadbalancers, instances in group will be remove from loadbalancer's `Default Server Group`; On the contrary, When attach loadbalancers, instances in group will be added to loadbalancer's `Default Server Group`.
 * > **NOTE:** When detach dbInstances, private ip of instances in group will be remove from dbInstance's `WhiteList`; On the contrary, When attach dbInstances, private ip of instances in group will be added to dbInstance's `WhiteList`.
 * > **NOTE:** `on_demand_base_capacity`,`on_demand_percentage_above_base_capacity`,`spot_instance_pools`,`spot_instance_remedy` are valid only if `multi_az_policy` is 'COST_OPTIMIZED'.
 * @property weightedCapacity The weight of the instance type in launchTemplateOverride.
 */
public data class ScalingGroupLaunchTemplateOverrideArgs(
    public val instanceType: Output<String>? = null,
    public val spotPriceLimit: Output<Double>? = null,
    public val weightedCapacity: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.inputs.ScalingGroupLaunchTemplateOverrideArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.inputs.ScalingGroupLaunchTemplateOverrideArgs =
        com.pulumi.alicloud.ess.inputs.ScalingGroupLaunchTemplateOverrideArgs.builder()
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .spotPriceLimit(spotPriceLimit?.applyValue({ args0 -> args0 }))
            .weightedCapacity(weightedCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScalingGroupLaunchTemplateOverrideArgs].
 */
@PulumiTagMarker
public class ScalingGroupLaunchTemplateOverrideArgsBuilder internal constructor() {
    private var instanceType: Output<String>? = null

    private var spotPriceLimit: Output<Double>? = null

    private var weightedCapacity: Output<Int>? = null

    /**
     * @param value The instance type in launchTemplateOverride.
     */
    @JvmName("gnrfoplnwegnvinf")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The maximum bid price of instance type in launchTemplateOverride.
     * > **NOTE:** When detach loadbalancers, instances in group will be remove from loadbalancer's `Default Server Group`; On the contrary, When attach loadbalancers, instances in group will be added to loadbalancer's `Default Server Group`.
     * > **NOTE:** When detach dbInstances, private ip of instances in group will be remove from dbInstance's `WhiteList`; On the contrary, When attach dbInstances, private ip of instances in group will be added to dbInstance's `WhiteList`.
     * > **NOTE:** `on_demand_base_capacity`,`on_demand_percentage_above_base_capacity`,`spot_instance_pools`,`spot_instance_remedy` are valid only if `multi_az_policy` is 'COST_OPTIMIZED'.
     */
    @JvmName("fabjfwvkupvowxju")
    public suspend fun spotPriceLimit(`value`: Output<Double>) {
        this.spotPriceLimit = value
    }

    /**
     * @param value The weight of the instance type in launchTemplateOverride.
     */
    @JvmName("srhlvjkfcgmdmtfw")
    public suspend fun weightedCapacity(`value`: Output<Int>) {
        this.weightedCapacity = value
    }

    /**
     * @param value The instance type in launchTemplateOverride.
     */
    @JvmName("stjljpmhmcoutbgo")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The maximum bid price of instance type in launchTemplateOverride.
     * > **NOTE:** When detach loadbalancers, instances in group will be remove from loadbalancer's `Default Server Group`; On the contrary, When attach loadbalancers, instances in group will be added to loadbalancer's `Default Server Group`.
     * > **NOTE:** When detach dbInstances, private ip of instances in group will be remove from dbInstance's `WhiteList`; On the contrary, When attach dbInstances, private ip of instances in group will be added to dbInstance's `WhiteList`.
     * > **NOTE:** `on_demand_base_capacity`,`on_demand_percentage_above_base_capacity`,`spot_instance_pools`,`spot_instance_remedy` are valid only if `multi_az_policy` is 'COST_OPTIMIZED'.
     */
    @JvmName("gdelwknikjlnkwjo")
    public suspend fun spotPriceLimit(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotPriceLimit = mapped
    }

    /**
     * @param value The weight of the instance type in launchTemplateOverride.
     */
    @JvmName("ejdgoanjrvlfiynx")
    public suspend fun weightedCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weightedCapacity = mapped
    }

    internal fun build(): ScalingGroupLaunchTemplateOverrideArgs =
        ScalingGroupLaunchTemplateOverrideArgs(
            instanceType = instanceType,
            spotPriceLimit = spotPriceLimit,
            weightedCapacity = weightedCapacity,
        )
}
