@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.inputs

import com.pulumi.alicloud.ess.inputs.ScalingGroupVServerGroupsVserverGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property loadbalancerId Loadbalancer server ID of VServer Group.
 * @property vserverAttributes A list of VServer Group attributes. See `vserver_attributes` below.
 */
public data class ScalingGroupVServerGroupsVserverGroupArgs(
    public val loadbalancerId: Output<String>,
    public val vserverAttributes: Output<List<ScalingGroupVServerGroupsVserverGroupVserverAttributeArgs>>,
) : ConvertibleToJava<com.pulumi.alicloud.ess.inputs.ScalingGroupVServerGroupsVserverGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.inputs.ScalingGroupVServerGroupsVserverGroupArgs =
        com.pulumi.alicloud.ess.inputs.ScalingGroupVServerGroupsVserverGroupArgs.builder()
            .loadbalancerId(loadbalancerId.applyValue({ args0 -> args0 }))
            .vserverAttributes(
                vserverAttributes.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ScalingGroupVServerGroupsVserverGroupArgs].
 */
@PulumiTagMarker
public class ScalingGroupVServerGroupsVserverGroupArgsBuilder internal constructor() {
    private var loadbalancerId: Output<String>? = null

    private var vserverAttributes:
        Output<List<ScalingGroupVServerGroupsVserverGroupVserverAttributeArgs>>? = null

    /**
     * @param value Loadbalancer server ID of VServer Group.
     */
    @JvmName("dqusehjsqkbrpldl")
    public suspend fun loadbalancerId(`value`: Output<String>) {
        this.loadbalancerId = value
    }

    /**
     * @param value A list of VServer Group attributes. See `vserver_attributes` below.
     */
    @JvmName("ehdwtxeciscpcmwq")
    public suspend fun vserverAttributes(`value`: Output<List<ScalingGroupVServerGroupsVserverGroupVserverAttributeArgs>>) {
        this.vserverAttributes = value
    }

    @JvmName("bljnyplcjejxvpoa")
    public suspend fun vserverAttributes(vararg values: Output<ScalingGroupVServerGroupsVserverGroupVserverAttributeArgs>) {
        this.vserverAttributes = Output.all(values.asList())
    }

    /**
     * @param values A list of VServer Group attributes. See `vserver_attributes` below.
     */
    @JvmName("ffrwxkndmfrbqryv")
    public suspend fun vserverAttributes(values: List<Output<ScalingGroupVServerGroupsVserverGroupVserverAttributeArgs>>) {
        this.vserverAttributes = Output.all(values)
    }

    /**
     * @param value Loadbalancer server ID of VServer Group.
     */
    @JvmName("efagoobcitjimgvb")
    public suspend fun loadbalancerId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadbalancerId = mapped
    }

    /**
     * @param value A list of VServer Group attributes. See `vserver_attributes` below.
     */
    @JvmName("xetblvcyeneepccj")
    public suspend fun vserverAttributes(`value`: List<ScalingGroupVServerGroupsVserverGroupVserverAttributeArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vserverAttributes = mapped
    }

    /**
     * @param argument A list of VServer Group attributes. See `vserver_attributes` below.
     */
    @JvmName("ybbxgdurkqhbfxvx")
    public suspend fun vserverAttributes(argument: List<suspend ScalingGroupVServerGroupsVserverGroupVserverAttributeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScalingGroupVServerGroupsVserverGroupVserverAttributeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vserverAttributes = mapped
    }

    /**
     * @param argument A list of VServer Group attributes. See `vserver_attributes` below.
     */
    @JvmName("opnsegftjpljgqgq")
    public suspend fun vserverAttributes(vararg argument: suspend ScalingGroupVServerGroupsVserverGroupVserverAttributeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScalingGroupVServerGroupsVserverGroupVserverAttributeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vserverAttributes = mapped
    }

    /**
     * @param argument A list of VServer Group attributes. See `vserver_attributes` below.
     */
    @JvmName("whteqyslhuhkxumr")
    public suspend fun vserverAttributes(argument: suspend ScalingGroupVServerGroupsVserverGroupVserverAttributeArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ScalingGroupVServerGroupsVserverGroupVserverAttributeArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.vserverAttributes = mapped
    }

    /**
     * @param values A list of VServer Group attributes. See `vserver_attributes` below.
     */
    @JvmName("rgtecqgrqkfruxny")
    public suspend fun vserverAttributes(vararg values: ScalingGroupVServerGroupsVserverGroupVserverAttributeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vserverAttributes = mapped
    }

    internal fun build(): ScalingGroupVServerGroupsVserverGroupArgs =
        ScalingGroupVServerGroupsVserverGroupArgs(
            loadbalancerId = loadbalancerId ?: throw PulumiNullFieldException("loadbalancerId"),
            vserverAttributes = vserverAttributes ?: throw PulumiNullFieldException("vserverAttributes"),
        )
}
