@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.inputs

import com.pulumi.alicloud.ess.inputs.ScalingGroupVServerGroupsVserverGroupVserverAttributeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property port The port will be used for VServer Group backend server.
 * @property vserverGroupId ID of VServer Group.
 * @property weight The weight of an ECS instance attached to the VServer Group.
 */
public data class ScalingGroupVServerGroupsVserverGroupVserverAttributeArgs(
    public val port: Output<Int>,
    public val vserverGroupId: Output<String>,
    public val weight: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.alicloud.ess.inputs.ScalingGroupVServerGroupsVserverGroupVserverAttributeArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.inputs.ScalingGroupVServerGroupsVserverGroupVserverAttributeArgs =
        com.pulumi.alicloud.ess.inputs.ScalingGroupVServerGroupsVserverGroupVserverAttributeArgs.builder()
            .port(port.applyValue({ args0 -> args0 }))
            .vserverGroupId(vserverGroupId.applyValue({ args0 -> args0 }))
            .weight(weight.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScalingGroupVServerGroupsVserverGroupVserverAttributeArgs].
 */
@PulumiTagMarker
public class ScalingGroupVServerGroupsVserverGroupVserverAttributeArgsBuilder internal constructor() {
    private var port: Output<Int>? = null

    private var vserverGroupId: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value The port will be used for VServer Group backend server.
     */
    @JvmName("qytnktcypggxpryu")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value ID of VServer Group.
     */
    @JvmName("rlmxodtqdfadohlq")
    public suspend fun vserverGroupId(`value`: Output<String>) {
        this.vserverGroupId = value
    }

    /**
     * @param value The weight of an ECS instance attached to the VServer Group.
     */
    @JvmName("fgjddoceavrmnpku")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value The port will be used for VServer Group backend server.
     */
    @JvmName("aertaxfhxwsyrhup")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value ID of VServer Group.
     */
    @JvmName("bmasxhpbxwswlmvu")
    public suspend fun vserverGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vserverGroupId = mapped
    }

    /**
     * @param value The weight of an ECS instance attached to the VServer Group.
     */
    @JvmName("tjgkdlmwlhywxhof")
    public suspend fun weight(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): ScalingGroupVServerGroupsVserverGroupVserverAttributeArgs =
        ScalingGroupVServerGroupsVserverGroupVserverAttributeArgs(
            port = port ?: throw PulumiNullFieldException("port"),
            vserverGroupId = vserverGroupId ?: throw PulumiNullFieldException("vserverGroupId"),
            weight = weight ?: throw PulumiNullFieldException("weight"),
        )
}
