@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.inputs

import com.pulumi.alicloud.ess.inputs.ScalingRuleAlarmDimensionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dimensionKey The dimension key of the metric.
 * @property dimensionValue The dimension value of the metric.
 */
public data class ScalingRuleAlarmDimensionArgs(
    public val dimensionKey: Output<String>? = null,
    public val dimensionValue: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.inputs.ScalingRuleAlarmDimensionArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.inputs.ScalingRuleAlarmDimensionArgs =
        com.pulumi.alicloud.ess.inputs.ScalingRuleAlarmDimensionArgs.builder()
            .dimensionKey(dimensionKey?.applyValue({ args0 -> args0 }))
            .dimensionValue(dimensionValue?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScalingRuleAlarmDimensionArgs].
 */
@PulumiTagMarker
public class ScalingRuleAlarmDimensionArgsBuilder internal constructor() {
    private var dimensionKey: Output<String>? = null

    private var dimensionValue: Output<String>? = null

    /**
     * @param value The dimension key of the metric.
     */
    @JvmName("bdbcxhccqlfbhssl")
    public suspend fun dimensionKey(`value`: Output<String>) {
        this.dimensionKey = value
    }

    /**
     * @param value The dimension value of the metric.
     */
    @JvmName("qkukdlmuvbwkjxmk")
    public suspend fun dimensionValue(`value`: Output<String>) {
        this.dimensionValue = value
    }

    /**
     * @param value The dimension key of the metric.
     */
    @JvmName("fsubnebqoyfslocd")
    public suspend fun dimensionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensionKey = mapped
    }

    /**
     * @param value The dimension value of the metric.
     */
    @JvmName("bltkwakhbrdmfduq")
    public suspend fun dimensionValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensionValue = mapped
    }

    internal fun build(): ScalingRuleAlarmDimensionArgs = ScalingRuleAlarmDimensionArgs(
        dimensionKey = dimensionKey,
        dimensionValue = dimensionValue,
    )
}
