@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.inputs

import com.pulumi.alicloud.ess.inputs.ScalingRuleStepAdjustmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property metricIntervalLowerBound The lower bound of step.
 * @property metricIntervalUpperBound The upper bound of step.
 * @property scalingAdjustment The adjust value of step.
 */
public data class ScalingRuleStepAdjustmentArgs(
    public val metricIntervalLowerBound: Output<String>? = null,
    public val metricIntervalUpperBound: Output<String>? = null,
    public val scalingAdjustment: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.inputs.ScalingRuleStepAdjustmentArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.inputs.ScalingRuleStepAdjustmentArgs =
        com.pulumi.alicloud.ess.inputs.ScalingRuleStepAdjustmentArgs.builder()
            .metricIntervalLowerBound(metricIntervalLowerBound?.applyValue({ args0 -> args0 }))
            .metricIntervalUpperBound(metricIntervalUpperBound?.applyValue({ args0 -> args0 }))
            .scalingAdjustment(scalingAdjustment?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScalingRuleStepAdjustmentArgs].
 */
@PulumiTagMarker
public class ScalingRuleStepAdjustmentArgsBuilder internal constructor() {
    private var metricIntervalLowerBound: Output<String>? = null

    private var metricIntervalUpperBound: Output<String>? = null

    private var scalingAdjustment: Output<Int>? = null

    /**
     * @param value The lower bound of step.
     */
    @JvmName("gfrbwuyhwqndgfcb")
    public suspend fun metricIntervalLowerBound(`value`: Output<String>) {
        this.metricIntervalLowerBound = value
    }

    /**
     * @param value The upper bound of step.
     */
    @JvmName("gwoggxnpptcrxrir")
    public suspend fun metricIntervalUpperBound(`value`: Output<String>) {
        this.metricIntervalUpperBound = value
    }

    /**
     * @param value The adjust value of step.
     */
    @JvmName("yhqbfyfdxyqpiata")
    public suspend fun scalingAdjustment(`value`: Output<Int>) {
        this.scalingAdjustment = value
    }

    /**
     * @param value The lower bound of step.
     */
    @JvmName("sxpxbvbrbwgxqqto")
    public suspend fun metricIntervalLowerBound(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricIntervalLowerBound = mapped
    }

    /**
     * @param value The upper bound of step.
     */
    @JvmName("dyvglhvdugswwabd")
    public suspend fun metricIntervalUpperBound(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricIntervalUpperBound = mapped
    }

    /**
     * @param value The adjust value of step.
     */
    @JvmName("yqetoiecuxhhbcdq")
    public suspend fun scalingAdjustment(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingAdjustment = mapped
    }

    internal fun build(): ScalingRuleStepAdjustmentArgs = ScalingRuleStepAdjustmentArgs(
        metricIntervalLowerBound = metricIntervalLowerBound,
        metricIntervalUpperBound = metricIntervalUpperBound,
        scalingAdjustment = scalingAdjustment,
    )
}
