@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property comparisonOperator The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand. Supported value: >=, <=, >, <. Defaults to >=.
 * @property metricName The name for the alarm's associated metric. See `dimensions` below for details.
 * @property period The period in seconds over which the specified statistic is applied. Supported value: 60, 120, 300, 900. Defaults to 300.
 * @property statistics The statistic to apply to the alarm's associated metric. Supported value: Average, Minimum, Maximum. Defaults to Average.
 * @property threshold The value against which the specified statistics is compared.
 */
public data class AlarmExpression(
    public val comparisonOperator: String? = null,
    public val metricName: String? = null,
    public val period: Int? = null,
    public val statistics: String? = null,
    public val threshold: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.AlarmExpression): AlarmExpression = AlarmExpression(
            comparisonOperator = javaType.comparisonOperator().map({ args0 -> args0 }).orElse(null),
            metricName = javaType.metricName().map({ args0 -> args0 }).orElse(null),
            period = javaType.period().map({ args0 -> args0 }).orElse(null),
            statistics = javaType.statistics().map({ args0 -> args0 }).orElse(null),
            threshold = javaType.threshold().map({ args0 -> args0 }).orElse(null),
        )
    }
}
