@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property domains Endpoint of Container Registry Enterprise Edition instance. By default, all endpoints of the Container Registry Enterprise Edition instance are displayed. It is required
 * when `acr_registry_info` is configured.
 * @property instanceId The ID of Container Registry Enterprise Edition instance. It is required
 * when `acr_registry_info` is configured.
 * @property instanceName The name of Container Registry Enterprise Edition instance. It is required when `acr_registry_info` is
 * configured.
 * @property regionId The region ID of Container Registry Enterprise Edition instance. It is required
 * when `acr_registry_info` is configured.
 */
public data class EciScalingConfigurationAcrRegistryInfo(
    public val domains: List<String>? = null,
    public val instanceId: String? = null,
    public val instanceName: String? = null,
    public val regionId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.EciScalingConfigurationAcrRegistryInfo): EciScalingConfigurationAcrRegistryInfo = EciScalingConfigurationAcrRegistryInfo(
            domains = javaType.domains().map({ args0 -> args0 }),
            instanceId = javaType.instanceId().map({ args0 -> args0 }).orElse(null),
            instanceName = javaType.instanceName().map({ args0 -> args0 }).orElse(null),
            regionId = javaType.regionId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
