@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property args The arguments passed to the commands.
 * @property commands The commands run by the init container.
 * @property cpu The amount of CPU resources allocated to the container.
 * @property environmentVars The structure of environmentVars.
 * See `environment_vars` below for details.
 * @property gpu The number GPUs.
 * @property image The image of the container.
 * @property imagePullPolicy The restart policy of the image.
 * @property lifecyclePreStopHandlerExecs The commands to be executed in containers when you use the CLI to specify the preStop callback function.
 * @property livenessProbeExecCommands Commands that you want to run in containers when you use the CLI to perform liveness probes.
 * @property livenessProbeFailureThreshold The minimum number of consecutive failures for the liveness probe to be considered failed after having been successful. Default value: 3.
 * @property livenessProbeHttpGetPath The path to which HTTP GET requests are sent when you use HTTP requests to perform liveness probes.
 * @property livenessProbeHttpGetPort The port to which HTTP GET requests are sent when you use HTTP requests to perform liveness probes.
 * @property livenessProbeHttpGetScheme The protocol type of HTTP GET requests when you use HTTP requests for liveness probes.Valid values:HTTP and HTTPS.
 * @property livenessProbeInitialDelaySeconds The number of seconds after container has started before liveness probes are initiated.
 * @property livenessProbePeriodSeconds The interval at which the liveness probe is performed. Unit: seconds. Default value: 10. Minimum value: 1.
 * @property livenessProbeSuccessThreshold The minimum number of consecutive successes for the liveness probe to be considered successful after having failed. Default value: 1. Set the value to 1.
 * @property livenessProbeTcpSocketPort The port detected by TCP sockets when you use TCP sockets to perform liveness probes.
 * @property livenessProbeTimeoutSeconds The timeout period for the liveness probe. Unit: seconds. Default value: 1. Minimum value: 1.
 * @property memory The amount of memory resources allocated to the container.
 * @property name The name of the mounted volume.
 * @property ports The structure of port. See `ports` below for details.
 * @property readinessProbeExecCommands Commands that you want to run in containers when you use the CLI to perform readiness probes.
 * @property readinessProbeFailureThreshold The minimum number of consecutive failures for the readiness probe to be considered failed after having been successful. Default value: 3.
 * @property readinessProbeHttpGetPath The path to which HTTP GET requests are sent when you use HTTP requests to perform readiness probes.
 * @property readinessProbeHttpGetPort The port to which HTTP GET requests are sent when you use HTTP requests to perform readiness probes.
 * @property readinessProbeHttpGetScheme The protocol type of HTTP GET requests when you use HTTP requests for readiness probes. Valid values: HTTP and HTTPS.
 * @property readinessProbeInitialDelaySeconds The number of seconds after container N has started before readiness probes are initiated.
 * @property readinessProbePeriodSeconds The interval at which the readiness probe is performed. Unit: seconds. Default value: 10. Minimum value: 1.
 * @property readinessProbeSuccessThreshold The minimum number of consecutive successes for the readiness probe to be considered successful after having failed. Default value: 1. Set the value to 1.
 * @property readinessProbeTcpSocketPort The port detected by Transmission Control Protocol (TCP) sockets when you use TCP sockets to perform readiness probes.
 * @property readinessProbeTimeoutSeconds The timeout period for the readiness probe. Unit: seconds. Default value: 1. Minimum value: 1.
 * @property securityContextCapabilityAdds Grant certain permissions to processes within container. Optional values:
 * - NET_ADMIN: Allow network management tasks to be performed.
 * - NET_RAW: Allow raw sockets.
 * @property securityContextReadOnlyRootFileSystem Mounts the container's root filesystem as read-only.
 * @property securityContextRunAsUser Specifies user ID  under which all processes run.
 * @property volumeMounts The structure of volumeMounts.
 * See `volume_mounts` below for details.
 * @property workingDir The working directory of the container.
 */
public data class EciScalingConfigurationContainer(
    public val args: List<String>? = null,
    public val commands: List<String>? = null,
    public val cpu: Double? = null,
    public val environmentVars: List<EciScalingConfigurationContainerEnvironmentVar>? = null,
    public val gpu: Int? = null,
    public val image: String? = null,
    public val imagePullPolicy: String? = null,
    public val lifecyclePreStopHandlerExecs: List<String>? = null,
    public val livenessProbeExecCommands: List<String>? = null,
    public val livenessProbeFailureThreshold: Int? = null,
    public val livenessProbeHttpGetPath: String? = null,
    public val livenessProbeHttpGetPort: Int? = null,
    public val livenessProbeHttpGetScheme: String? = null,
    public val livenessProbeInitialDelaySeconds: Int? = null,
    public val livenessProbePeriodSeconds: Int? = null,
    public val livenessProbeSuccessThreshold: Int? = null,
    public val livenessProbeTcpSocketPort: Int? = null,
    public val livenessProbeTimeoutSeconds: Int? = null,
    public val memory: Double? = null,
    public val name: String? = null,
    public val ports: List<EciScalingConfigurationContainerPort>? = null,
    public val readinessProbeExecCommands: List<String>? = null,
    public val readinessProbeFailureThreshold: Int? = null,
    public val readinessProbeHttpGetPath: String? = null,
    public val readinessProbeHttpGetPort: Int? = null,
    public val readinessProbeHttpGetScheme: String? = null,
    public val readinessProbeInitialDelaySeconds: Int? = null,
    public val readinessProbePeriodSeconds: Int? = null,
    public val readinessProbeSuccessThreshold: Int? = null,
    public val readinessProbeTcpSocketPort: Int? = null,
    public val readinessProbeTimeoutSeconds: Int? = null,
    public val securityContextCapabilityAdds: List<String>? = null,
    public val securityContextReadOnlyRootFileSystem: Boolean? = null,
    public val securityContextRunAsUser: Int? = null,
    public val volumeMounts: List<EciScalingConfigurationContainerVolumeMount>? = null,
    public val workingDir: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.EciScalingConfigurationContainer): EciScalingConfigurationContainer = EciScalingConfigurationContainer(
            args = javaType.args().map({ args0 -> args0 }),
            commands = javaType.commands().map({ args0 -> args0 }),
            cpu = javaType.cpu().map({ args0 -> args0 }).orElse(null),
            environmentVars = javaType.environmentVars().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ess.kotlin.outputs.EciScalingConfigurationContainerEnvironmentVar.Companion.toKotlin(args0)
                })
            }),
            gpu = javaType.gpu().map({ args0 -> args0 }).orElse(null),
            image = javaType.image().map({ args0 -> args0 }).orElse(null),
            imagePullPolicy = javaType.imagePullPolicy().map({ args0 -> args0 }).orElse(null),
            lifecyclePreStopHandlerExecs = javaType.lifecyclePreStopHandlerExecs().map({ args0 -> args0 }),
            livenessProbeExecCommands = javaType.livenessProbeExecCommands().map({ args0 -> args0 }),
            livenessProbeFailureThreshold = javaType.livenessProbeFailureThreshold().map({ args0 ->
                args0
            }).orElse(null),
            livenessProbeHttpGetPath = javaType.livenessProbeHttpGetPath().map({ args0 -> args0 }).orElse(null),
            livenessProbeHttpGetPort = javaType.livenessProbeHttpGetPort().map({ args0 -> args0 }).orElse(null),
            livenessProbeHttpGetScheme = javaType.livenessProbeHttpGetScheme().map({ args0 ->
                args0
            }).orElse(null),
            livenessProbeInitialDelaySeconds = javaType.livenessProbeInitialDelaySeconds().map({ args0 ->
                args0
            }).orElse(null),
            livenessProbePeriodSeconds = javaType.livenessProbePeriodSeconds().map({ args0 ->
                args0
            }).orElse(null),
            livenessProbeSuccessThreshold = javaType.livenessProbeSuccessThreshold().map({ args0 ->
                args0
            }).orElse(null),
            livenessProbeTcpSocketPort = javaType.livenessProbeTcpSocketPort().map({ args0 ->
                args0
            }).orElse(null),
            livenessProbeTimeoutSeconds = javaType.livenessProbeTimeoutSeconds().map({ args0 ->
                args0
            }).orElse(null),
            memory = javaType.memory().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            ports = javaType.ports().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ess.kotlin.outputs.EciScalingConfigurationContainerPort.Companion.toKotlin(args0)
                })
            }),
            readinessProbeExecCommands = javaType.readinessProbeExecCommands().map({ args0 -> args0 }),
            readinessProbeFailureThreshold = javaType.readinessProbeFailureThreshold().map({ args0 ->
                args0
            }).orElse(null),
            readinessProbeHttpGetPath = javaType.readinessProbeHttpGetPath().map({ args0 ->
                args0
            }).orElse(null),
            readinessProbeHttpGetPort = javaType.readinessProbeHttpGetPort().map({ args0 ->
                args0
            }).orElse(null),
            readinessProbeHttpGetScheme = javaType.readinessProbeHttpGetScheme().map({ args0 ->
                args0
            }).orElse(null),
            readinessProbeInitialDelaySeconds = javaType.readinessProbeInitialDelaySeconds().map({ args0 ->
                args0
            }).orElse(null),
            readinessProbePeriodSeconds = javaType.readinessProbePeriodSeconds().map({ args0 ->
                args0
            }).orElse(null),
            readinessProbeSuccessThreshold = javaType.readinessProbeSuccessThreshold().map({ args0 ->
                args0
            }).orElse(null),
            readinessProbeTcpSocketPort = javaType.readinessProbeTcpSocketPort().map({ args0 ->
                args0
            }).orElse(null),
            readinessProbeTimeoutSeconds = javaType.readinessProbeTimeoutSeconds().map({ args0 ->
                args0
            }).orElse(null),
            securityContextCapabilityAdds = javaType.securityContextCapabilityAdds().map({ args0 -> args0 }),
            securityContextReadOnlyRootFileSystem = javaType.securityContextReadOnlyRootFileSystem().map({ args0 ->
                args0
            }).orElse(null),
            securityContextRunAsUser = javaType.securityContextRunAsUser().map({ args0 -> args0 }).orElse(null),
            volumeMounts = javaType.volumeMounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ess.kotlin.outputs.EciScalingConfigurationContainerVolumeMount.Companion.toKotlin(args0)
                })
            }),
            workingDir = javaType.workingDir().map({ args0 -> args0 }).orElse(null),
        )
    }
}
