@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property hostnames Adds a host name.
 * @property ip Adds an IP address.
 */
public data class EciScalingConfigurationHostAlias(
    public val hostnames: List<String>? = null,
    public val ip: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.EciScalingConfigurationHostAlias): EciScalingConfigurationHostAlias = EciScalingConfigurationHostAlias(
            hostnames = javaType.hostnames().map({ args0 -> args0 }),
            ip = javaType.ip().map({ args0 -> args0 }).orElse(null),
        )
    }
}
