@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property password The password used to log on to the image repository. It is required
 * when `image_registry_credential` is configured.
 * @property server The address of the image repository. It is required when `image_registry_credential` is
 * configured.
 * @property username The username used to log on to the image repository. It is required
 * when `image_registry_credential` is configured.
 */
public data class EciScalingConfigurationImageRegistryCredential(
    public val password: String? = null,
    public val server: String? = null,
    public val username: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.EciScalingConfigurationImageRegistryCredential): EciScalingConfigurationImageRegistryCredential =
            EciScalingConfigurationImageRegistryCredential(
                password = javaType.password().map({ args0 -> args0 }).orElse(null),
                server = javaType.server().map({ args0 -> args0 }).orElse(null),
                username = javaType.username().map({ args0 -> args0 }).orElse(null),
            )
    }
}
