@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property args The arguments passed to the commands.
 * @property commands The commands run by the init container.
 * @property cpu The amount of CPU resources allocated to the container.
 * @property environmentVars The structure of environmentVars.
 * See `environment_vars` below for details.
 * @property gpu The number GPUs.
 * @property image The image of the container.
 * @property imagePullPolicy The restart policy of the image.
 * @property memory The amount of memory resources allocated to the container.
 * @property name The name of the mounted volume.
 * @property ports The structure of port. See `ports` below for details.
 * @property securityContextCapabilityAdds Grant certain permissions to processes within container. Optional values:
 * - NET_ADMIN: Allow network management tasks to be performed.
 * - NET_RAW: Allow raw sockets.
 * @property securityContextReadOnlyRootFileSystem Mounts the container's root filesystem as read-only.
 * @property securityContextRunAsUser Specifies user ID  under which all processes run.
 * @property volumeMounts The structure of volumeMounts. See `volume_mounts` below for details.
 * @property workingDir The working directory of the container.
 */
public data class EciScalingConfigurationInitContainer(
    public val args: List<String>? = null,
    public val commands: List<String>? = null,
    public val cpu: Double? = null,
    public val environmentVars: List<EciScalingConfigurationInitContainerEnvironmentVar>? = null,
    public val gpu: Int? = null,
    public val image: String? = null,
    public val imagePullPolicy: String? = null,
    public val memory: Double? = null,
    public val name: String? = null,
    public val ports: List<EciScalingConfigurationInitContainerPort>? = null,
    public val securityContextCapabilityAdds: List<String>? = null,
    public val securityContextReadOnlyRootFileSystem: Boolean? = null,
    public val securityContextRunAsUser: Int? = null,
    public val volumeMounts: List<EciScalingConfigurationInitContainerVolumeMount>? = null,
    public val workingDir: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.EciScalingConfigurationInitContainer): EciScalingConfigurationInitContainer = EciScalingConfigurationInitContainer(
            args = javaType.args().map({ args0 -> args0 }),
            commands = javaType.commands().map({ args0 -> args0 }),
            cpu = javaType.cpu().map({ args0 -> args0 }).orElse(null),
            environmentVars = javaType.environmentVars().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ess.kotlin.outputs.EciScalingConfigurationInitContainerEnvironmentVar.Companion.toKotlin(args0)
                })
            }),
            gpu = javaType.gpu().map({ args0 -> args0 }).orElse(null),
            image = javaType.image().map({ args0 -> args0 }).orElse(null),
            imagePullPolicy = javaType.imagePullPolicy().map({ args0 -> args0 }).orElse(null),
            memory = javaType.memory().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            ports = javaType.ports().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ess.kotlin.outputs.EciScalingConfigurationInitContainerPort.Companion.toKotlin(args0)
                })
            }),
            securityContextCapabilityAdds = javaType.securityContextCapabilityAdds().map({ args0 -> args0 }),
            securityContextReadOnlyRootFileSystem = javaType.securityContextReadOnlyRootFileSystem().map({ args0 ->
                args0
            }).orElse(null),
            securityContextRunAsUser = javaType.securityContextRunAsUser().map({ args0 -> args0 }).orElse(null),
            volumeMounts = javaType.volumeMounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ess.kotlin.outputs.EciScalingConfigurationInitContainerVolumeMount.Companion.toKotlin(args0)
                })
            }),
            workingDir = javaType.workingDir().map({ args0 -> args0 }).orElse(null),
        )
    }
}
