@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property configFileVolumeConfigFileToPaths ConfigFileVolumeConfigFileToPaths.
 * See `config_file_volume_config_file_to_paths` below for details.
 * @property diskVolumeDiskId The ID of DiskVolume.
 * @property diskVolumeDiskSize The disk size of DiskVolume.
 * @property diskVolumeFsType The system type of DiskVolume.
 * @property flexVolumeDriver The name of the FlexVolume driver.
 * @property flexVolumeFsType The type of the mounted file system. The default value is determined by the script
 * of FlexVolume.
 * @property flexVolumeOptions The list of FlexVolume objects. Each object is a key-value pair contained in a JSON
 * string.
 * @property name The name of the volume.
 * @property nfsVolumePath The path to the NFS volume.
 * @property nfsVolumeReadOnly The nfs volume read only. Default to `false`.
 * @property nfsVolumeServer The address of the NFS server.
 * > **NOTE:** Every volume mounted must have a name and type attributes.
 * @property type The type of the volume.
 */
public data class EciScalingConfigurationVolume(
    public val configFileVolumeConfigFileToPaths: List<EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPath>? = null,
    public val diskVolumeDiskId: String? = null,
    public val diskVolumeDiskSize: Int? = null,
    public val diskVolumeFsType: String? = null,
    public val flexVolumeDriver: String? = null,
    public val flexVolumeFsType: String? = null,
    public val flexVolumeOptions: String? = null,
    public val name: String? = null,
    public val nfsVolumePath: String? = null,
    public val nfsVolumeReadOnly: Boolean? = null,
    public val nfsVolumeServer: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.EciScalingConfigurationVolume): EciScalingConfigurationVolume = EciScalingConfigurationVolume(
            configFileVolumeConfigFileToPaths = javaType.configFileVolumeConfigFileToPaths().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ess.kotlin.outputs.EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPath.Companion.toKotlin(args0)
                })
            }),
            diskVolumeDiskId = javaType.diskVolumeDiskId().map({ args0 -> args0 }).orElse(null),
            diskVolumeDiskSize = javaType.diskVolumeDiskSize().map({ args0 -> args0 }).orElse(null),
            diskVolumeFsType = javaType.diskVolumeFsType().map({ args0 -> args0 }).orElse(null),
            flexVolumeDriver = javaType.flexVolumeDriver().map({ args0 -> args0 }).orElse(null),
            flexVolumeFsType = javaType.flexVolumeFsType().map({ args0 -> args0 }).orElse(null),
            flexVolumeOptions = javaType.flexVolumeOptions().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            nfsVolumePath = javaType.nfsVolumePath().map({ args0 -> args0 }).orElse(null),
            nfsVolumeReadOnly = javaType.nfsVolumeReadOnly().map({ args0 -> args0 }).orElse(null),
            nfsVolumeServer = javaType.nfsVolumeServer().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
