@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property alarmActions The list of actions to execute when this alarm transition into an ALARM state. Each action is specified as ess scaling rule ari.
 * @property cloudMonitorGroupId Defines the application group id defined by CMS which is assigned when you upload custom metric to CMS, only available for custom metirc.
 * @property comparisonOperator The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand.
 * @property description The description for the alarm.
 * @property dimensions The dimension map for the alarm's associated metric.
 * @property enable Whether to enable specific ess alarm.
 * @property evaluationCount The number of times that needs to satisfies comparison condition before transition into ALARM state.
 * @property id The id of alarm.
 * @property metricName The name for the alarm's associated metric.
 * @property metricType The type for the alarm's associated metric. Supported value: system, custom. "system" means the metric data is collected by Aliyun Cloud Monitor Service(CMS), "custom" means the metric data is upload to CMS by users. Defaults to system.
 * @property name The name for ess alarm.
 * @property period The period in seconds over which the specified statistic is applied.
 * @property scalingGroupId Scaling group id the alarms belong to.
 * @property state The state of alarm task.
 * @property statistics The statistic to apply to the alarm's associated metric.
 * @property threshold The value against which the specified statistics is compared.
 */
public data class GetAlarmsAlarm(
    public val alarmActions: List<String>,
    public val cloudMonitorGroupId: Int,
    public val comparisonOperator: String,
    public val description: String,
    public val dimensions: Map<String, String>,
    public val enable: Boolean,
    public val evaluationCount: Int,
    public val id: String,
    public val metricName: String,
    public val metricType: String,
    public val name: String,
    public val period: Int,
    public val scalingGroupId: String,
    public val state: String,
    public val statistics: String,
    public val threshold: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.GetAlarmsAlarm): GetAlarmsAlarm =
            GetAlarmsAlarm(
                alarmActions = javaType.alarmActions().map({ args0 -> args0 }),
                cloudMonitorGroupId = javaType.cloudMonitorGroupId(),
                comparisonOperator = javaType.comparisonOperator(),
                description = javaType.description(),
                dimensions = javaType.dimensions().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                enable = javaType.enable(),
                evaluationCount = javaType.evaluationCount(),
                id = javaType.id(),
                metricName = javaType.metricName(),
                metricType = javaType.metricType(),
                name = javaType.name(),
                period = javaType.period(),
                scalingGroupId = javaType.scalingGroupId(),
                state = javaType.state(),
                statistics = javaType.statistics(),
                threshold = javaType.threshold(),
            )
    }
}
