@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAlarms.
 * @property alarms A list of alarms. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of alarm ids.
 * @property metricType The type for the alarm's associated metric.
 * @property nameRegex
 * @property names A list of alarm names.
 * @property outputFile
 * @property scalingGroupId The scaling group associated with this alarm.
 */
public data class GetAlarmsResult(
    public val alarms: List<GetAlarmsAlarm>,
    public val id: String,
    public val ids: List<String>,
    public val metricType: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val scalingGroupId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.GetAlarmsResult): GetAlarmsResult = GetAlarmsResult(
            alarms = javaType.alarms().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ess.kotlin.outputs.GetAlarmsAlarm.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            metricType = javaType.metricType().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            scalingGroupId = javaType.scalingGroupId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
