@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property defaultResult Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses.
 * @property heartbeatTimeout Defines the amount of time, in seconds, that can elapse before the lifecycle hook times out. When the lifecycle hook times out, Auto Scaling performs the action defined in the default_result parameter.
 * @property id ID of the lifecycle hook.
 * @property lifecycleTransition Type of Scaling activity attached to lifecycle hook.
 * @property name Name of the lifecycle hook.
 * @property notificationArn The Arn of notification target.
 * @property notificationMetadata Additional information that you want to include when Auto Scaling sends a message to the notification target.
 * @property scalingGroupId Scaling group id the lifecycle hooks belong to.
 */
public data class GetLifecycleHooksHook(
    public val defaultResult: String,
    public val heartbeatTimeout: Int,
    public val id: String,
    public val lifecycleTransition: String,
    public val name: String,
    public val notificationArn: String,
    public val notificationMetadata: String,
    public val scalingGroupId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.GetLifecycleHooksHook): GetLifecycleHooksHook = GetLifecycleHooksHook(
            defaultResult = javaType.defaultResult(),
            heartbeatTimeout = javaType.heartbeatTimeout(),
            id = javaType.id(),
            lifecycleTransition = javaType.lifecycleTransition(),
            name = javaType.name(),
            notificationArn = javaType.notificationArn(),
            notificationMetadata = javaType.notificationMetadata(),
            scalingGroupId = javaType.scalingGroupId(),
        )
    }
}
