@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property id ID of the notification.
 * @property notificationArn The Alibaba Cloud Resource Name (ARN) for the notification object.
 * @property notificationTypes The notification types of Auto Scaling events and resource changes.
 * @property scalingGroupId Scaling group id the notifications belong to.
 */
public data class GetNotificationsNotification(
    public val id: String,
    public val notificationArn: String,
    public val notificationTypes: List<String>,
    public val scalingGroupId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.GetNotificationsNotification): GetNotificationsNotification = GetNotificationsNotification(
            id = javaType.id(),
            notificationArn = javaType.notificationArn(),
            notificationTypes = javaType.notificationTypes().map({ args0 -> args0 }),
            scalingGroupId = javaType.scalingGroupId(),
        )
    }
}
