@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getNotifications.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of notification ids.
 * @property notifications A list of notifications. Each element contains the following attributes:
 * @property outputFile
 * @property scalingGroupId ID of the scaling group.
 */
public data class GetNotificationsResult(
    public val id: String,
    public val ids: List<String>? = null,
    public val notifications: List<GetNotificationsNotification>,
    public val outputFile: String? = null,
    public val scalingGroupId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.GetNotificationsResult): GetNotificationsResult = GetNotificationsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            notifications = javaType.notifications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ess.kotlin.outputs.GetNotificationsNotification.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            scalingGroupId = javaType.scalingGroupId(),
        )
    }
}
