@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property creationTime Creation time of the scaling configuration.
 * @property creditSpecification Performance mode of the t5 burstable instance.
 * @property dataDisks Data disks of the scaling configuration.
 * @property hostName (Optional,Available in 1.143.0+) Hostname of an ECS instance.
 * @property id ID of the scaling rule.
 * @property imageId Image ID of the scaling configuration.
 * @property instanceName (Optional,Available in 1.143.0+) InstanceName of an ECS instance.
 * @property instanceType Resource type of an ECS instance.
 * @property internetChargeType Internet charge type of the scaling configuration.
 * @property internetMaxBandwidthIn Internet max bandwidth in of the scaling configuration.
 * @property internetMaxBandwidthOut Internet max bandwidth of the scaling configuration.
 * @property lifecycleState Lifecycle state of the scaling configuration.
 * @property name Name of the scaling configuration.
 * @property scalingGroupId Scaling group id the scaling configurations belong to.
 * @property securityGroupId Security group ID of the scaling configuration.
 * @property spotPriceLimits (Optional, Available in 1.151.0+) The maximum price hourly for instance types.
 * @property spotStrategy (Optional, Available in 1.151.0+) The spot strategy for a Pay-As-You-Go instance.
 * @property systemDiskCategory System disk category of the scaling configuration.
 * @property systemDiskPerformanceLevel The performance level of the ESSD used as the system disk.
 * @property systemDiskSize System disk size of the scaling configuration.
 */
public data class GetScalingConfigurationsConfiguration(
    public val creationTime: String,
    public val creditSpecification: String,
    public val dataDisks: List<GetScalingConfigurationsConfigurationDataDisk>,
    public val hostName: String,
    public val id: String,
    public val imageId: String,
    public val instanceName: String,
    public val instanceType: String,
    public val internetChargeType: String,
    public val internetMaxBandwidthIn: Int,
    public val internetMaxBandwidthOut: Int,
    public val lifecycleState: String,
    public val name: String,
    public val scalingGroupId: String,
    public val securityGroupId: String,
    public val spotPriceLimits: List<GetScalingConfigurationsConfigurationSpotPriceLimit>,
    public val spotStrategy: String,
    public val systemDiskCategory: String,
    public val systemDiskPerformanceLevel: String,
    public val systemDiskSize: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.GetScalingConfigurationsConfiguration): GetScalingConfigurationsConfiguration = GetScalingConfigurationsConfiguration(
            creationTime = javaType.creationTime(),
            creditSpecification = javaType.creditSpecification(),
            dataDisks = javaType.dataDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ess.kotlin.outputs.GetScalingConfigurationsConfigurationDataDisk.Companion.toKotlin(args0)
                })
            }),
            hostName = javaType.hostName(),
            id = javaType.id(),
            imageId = javaType.imageId(),
            instanceName = javaType.instanceName(),
            instanceType = javaType.instanceType(),
            internetChargeType = javaType.internetChargeType(),
            internetMaxBandwidthIn = javaType.internetMaxBandwidthIn(),
            internetMaxBandwidthOut = javaType.internetMaxBandwidthOut(),
            lifecycleState = javaType.lifecycleState(),
            name = javaType.name(),
            scalingGroupId = javaType.scalingGroupId(),
            securityGroupId = javaType.securityGroupId(),
            spotPriceLimits = javaType.spotPriceLimits().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ess.kotlin.outputs.GetScalingConfigurationsConfigurationSpotPriceLimit.Companion.toKotlin(args0)
                })
            }),
            spotStrategy = javaType.spotStrategy(),
            systemDiskCategory = javaType.systemDiskCategory(),
            systemDiskPerformanceLevel = javaType.systemDiskPerformanceLevel(),
            systemDiskSize = javaType.systemDiskSize(),
        )
    }
}
