@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property category Category of data disk.
 * @property deleteWithInstance Delete_with_instance attribute of data disk.
 * @property device Device attribute of data disk.
 * @property performanceLevel The performance level of the ESSD used as data disk.
 * @property size Size of data disk.
 * @property snapshotId Size of data disk.
 */
public data class GetScalingConfigurationsConfigurationDataDisk(
    public val category: String,
    public val deleteWithInstance: Boolean,
    public val device: String,
    public val performanceLevel: String,
    public val size: Int,
    public val snapshotId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.GetScalingConfigurationsConfigurationDataDisk): GetScalingConfigurationsConfigurationDataDisk =
            GetScalingConfigurationsConfigurationDataDisk(
                category = javaType.category(),
                deleteWithInstance = javaType.deleteWithInstance(),
                device = javaType.device(),
                performanceLevel = javaType.performanceLevel(),
                size = javaType.size(),
                snapshotId = javaType.snapshotId(),
            )
    }
}
