@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property instanceType Resource type of an ECS instance.
 * @property priceLimit Price limit hourly of instance type.
 */
public data class GetScalingConfigurationsConfigurationSpotPriceLimit(
    public val instanceType: String,
    public val priceLimit: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.GetScalingConfigurationsConfigurationSpotPriceLimit): GetScalingConfigurationsConfigurationSpotPriceLimit =
            GetScalingConfigurationsConfigurationSpotPriceLimit(
                instanceType = javaType.instanceType(),
                priceLimit = javaType.priceLimit(),
            )
    }
}
