@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getScalingConfigurations.
 * @property configurations A list of scaling rules. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of scaling configuration ids.
 * @property nameRegex
 * @property names A list of scaling configuration names.
 * @property outputFile
 * @property scalingGroupId ID of the scaling group.
 */
public data class GetScalingConfigurationsResult(
    public val configurations: List<GetScalingConfigurationsConfiguration>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val scalingGroupId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.GetScalingConfigurationsResult): GetScalingConfigurationsResult = GetScalingConfigurationsResult(
            configurations = javaType.configurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ess.kotlin.outputs.GetScalingConfigurationsConfiguration.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            scalingGroupId = javaType.scalingGroupId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
