@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property activeCapacity Number of active instances in scaling group.
 * @property activeScalingConfiguration Active scaling configuration for scaling group.
 * @property cooldownTime Default cooldown time of scaling group.
 * @property creationTime Creation time of scaling group.
 * @property dbInstanceIds Db instances id which the ECS instance attached to.
 * @property groupDeletionProtection Whether the scaling group deletion protection is enabled.
 * @property healthCheckType The health check method of the scaling group.
 * @property id ID of the scaling group.
 * @property launchTemplateId Active launch template ID for scaling group.
 * @property launchTemplateVersion Version of active launch template.
 * @property lifecycleState Lifecycle state of scaling group.
 * @property loadBalancerIds Slb instances id which the ECS instance attached to.
 * @property maxSize The maximum number of ECS instances.
 * @property minSize The minimum number of ECS instances.
 * @property modificationTime The modification time.
 * @property name Name of the scaling group.
 * @property pendingCapacity Number of pending instances in scaling group.
 * @property regionId Region ID the scaling group belongs to.
 * @property removalPolicies Removal policy used to select the ECS instance to remove from the scaling group.
 * @property removingCapacity Number of removing instances in scaling group.
 * @property suspendedProcesses The Process in suspension.
 * @property tags A mapping of tags to assign to the resource.
 * @property totalCapacity Number of instances in scaling group.
 * @property totalInstanceCount The number of all ECS instances in the scaling group.
 * @property vpcId The ID of the VPC to which the scaling group belongs.
 * @property vswitchId The ID of the vSwitch to which the scaling group belongs.
 * @property vswitchIds Vswitches id in which the ECS instance launched.
 */
public data class GetScalingGroupsGroup(
    public val activeCapacity: Int,
    public val activeScalingConfiguration: String,
    public val cooldownTime: Int,
    public val creationTime: String,
    public val dbInstanceIds: List<String>,
    public val groupDeletionProtection: Boolean,
    public val healthCheckType: String,
    public val id: String,
    public val launchTemplateId: String,
    public val launchTemplateVersion: String,
    public val lifecycleState: String,
    public val loadBalancerIds: List<String>,
    public val maxSize: Int,
    public val minSize: Int,
    public val modificationTime: String,
    public val name: String,
    public val pendingCapacity: Int,
    public val regionId: String,
    public val removalPolicies: List<String>,
    public val removingCapacity: Int,
    public val suspendedProcesses: List<String>,
    public val tags: Map<String, String>? = null,
    public val totalCapacity: Int,
    public val totalInstanceCount: Int,
    public val vpcId: String,
    public val vswitchId: String,
    public val vswitchIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.GetScalingGroupsGroup): GetScalingGroupsGroup = GetScalingGroupsGroup(
            activeCapacity = javaType.activeCapacity(),
            activeScalingConfiguration = javaType.activeScalingConfiguration(),
            cooldownTime = javaType.cooldownTime(),
            creationTime = javaType.creationTime(),
            dbInstanceIds = javaType.dbInstanceIds().map({ args0 -> args0 }),
            groupDeletionProtection = javaType.groupDeletionProtection(),
            healthCheckType = javaType.healthCheckType(),
            id = javaType.id(),
            launchTemplateId = javaType.launchTemplateId(),
            launchTemplateVersion = javaType.launchTemplateVersion(),
            lifecycleState = javaType.lifecycleState(),
            loadBalancerIds = javaType.loadBalancerIds().map({ args0 -> args0 }),
            maxSize = javaType.maxSize(),
            minSize = javaType.minSize(),
            modificationTime = javaType.modificationTime(),
            name = javaType.name(),
            pendingCapacity = javaType.pendingCapacity(),
            regionId = javaType.regionId(),
            removalPolicies = javaType.removalPolicies().map({ args0 -> args0 }),
            removingCapacity = javaType.removingCapacity(),
            suspendedProcesses = javaType.suspendedProcesses().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            totalCapacity = javaType.totalCapacity(),
            totalInstanceCount = javaType.totalInstanceCount(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            vswitchIds = javaType.vswitchIds().map({ args0 -> args0 }),
        )
    }
}
