@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getScalingRules.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of scaling rule ids.
 * @property nameRegex
 * @property names A list of scaling rule names.
 * @property outputFile
 * @property rules A list of scaling rules. Each element contains the following attributes:
 * @property scalingGroupId ID of the scaling group.
 * @property type Type of the scaling rule.
 */
public data class GetScalingRulesResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val rules: List<GetScalingRulesRule>,
    public val scalingGroupId: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.GetScalingRulesResult): GetScalingRulesResult = GetScalingRulesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ess.kotlin.outputs.GetScalingRulesRule.Companion.toKotlin(args0)
                })
            }),
            scalingGroupId = javaType.scalingGroupId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
