@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property adjustmentType Adjustment type of the scaling rule.
 * @property adjustmentValue Adjustment value of the scaling rule.
 * @property cooldown Cooldown time of the scaling rule.
 * @property id ID of the scaling rule.
 * @property minAdjustmentMagnitude Min adjustment magnitude of scaling rule.
 * @property name Name of the scaling rule.
 * @property scalingGroupId Scaling group id the scaling rules belong to.
 * @property scalingRuleAri Ari of scaling rule.
 * @property type Type of scaling rule.
 */
public data class GetScalingRulesRule(
    public val adjustmentType: String,
    public val adjustmentValue: Int,
    public val cooldown: Int,
    public val id: String,
    public val minAdjustmentMagnitude: Int,
    public val name: String,
    public val scalingGroupId: String,
    public val scalingRuleAri: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.GetScalingRulesRule): GetScalingRulesRule = GetScalingRulesRule(
            adjustmentType = javaType.adjustmentType(),
            adjustmentValue = javaType.adjustmentValue(),
            cooldown = javaType.cooldown(),
            id = javaType.id(),
            minAdjustmentMagnitude = javaType.minAdjustmentMagnitude(),
            name = javaType.name(),
            scalingGroupId = javaType.scalingGroupId(),
            scalingRuleAri = javaType.scalingRuleAri(),
            type = javaType.type(),
        )
    }
}
