@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getScheduledTasks.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of scheduled task ids.
 * @property nameRegex
 * @property names A list of scheduled task names.
 * @property outputFile
 * @property scheduledAction The operation to be performed when a scheduled task is triggered.
 * @property scheduledTaskId
 * @property tasks A list of scheduled tasks. Each element contains the following attributes:
 */
public data class GetScheduledTasksResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val scheduledAction: String? = null,
    public val scheduledTaskId: String? = null,
    public val tasks: List<GetScheduledTasksTask>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.GetScheduledTasksResult): GetScheduledTasksResult = GetScheduledTasksResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            scheduledAction = javaType.scheduledAction().map({ args0 -> args0 }).orElse(null),
            scheduledTaskId = javaType.scheduledTaskId().map({ args0 -> args0 }).orElse(null),
            tasks = javaType.tasks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ess.kotlin.outputs.GetScheduledTasksTask.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
