@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description Description of the scheduled task.
 * @property id ID of the scheduled task id.
 * @property launchExpirationTime The time period during which a failed scheduled task is retried.
 * @property launchTime The time at which the scheduled task is triggered.
 * @property maxValue
 * @property minValue
 * @property name Name of the scheduled task name.
 * @property recurrenceEndTime Specifies the end time after which the scheduled task is no longer repeated.
 * @property recurrenceType Specifies the recurrence type of the scheduled task.
 * @property recurrenceValue Specifies how often a scheduled task recurs.
 * @property scheduledAction The operation to be performed when a scheduled task is triggered.
 * @property taskEnabled
 */
public data class GetScheduledTasksTask(
    public val description: String,
    public val id: String,
    public val launchExpirationTime: Int,
    public val launchTime: String,
    public val maxValue: Int,
    public val minValue: Int,
    public val name: String,
    public val recurrenceEndTime: String,
    public val recurrenceType: String,
    public val recurrenceValue: String,
    public val scheduledAction: String,
    public val taskEnabled: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.GetScheduledTasksTask): GetScheduledTasksTask = GetScheduledTasksTask(
            description = javaType.description(),
            id = javaType.id(),
            launchExpirationTime = javaType.launchExpirationTime(),
            launchTime = javaType.launchTime(),
            maxValue = javaType.maxValue(),
            minValue = javaType.minValue(),
            name = javaType.name(),
            recurrenceEndTime = javaType.recurrenceEndTime(),
            recurrenceType = javaType.recurrenceType(),
            recurrenceValue = javaType.recurrenceValue(),
            scheduledAction = javaType.scheduledAction(),
            taskEnabled = javaType.taskEnabled(),
        )
    }
}
