@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property architectures Architecture N of instance type N. Valid values: X86, Heterogeneous, BareMetal, Arm, SuperComputeCluster.
 * @property burstablePerformance Specifies whether to include burstable instance types.  Valid values: Exclude, Include, Required.
 * @property cores The number of vCPUs that are specified for an instance type in instancePatternInfo.
 * @property excludedInstanceTypes Instance type N that you want to exclude. You can use wildcard characters, such as an asterisk (*), to exclude an instance type or an instance family.
 * @property instanceFamilyLevel The instance family level in instancePatternInfo.
 * @property maxPrice The maximum hourly price for a pay-as-you-go instance or a preemptible instance in instancePatternInfo.
 * @property memory The memory size that is specified for an instance type in instancePatternInfo.
 */
public data class ScalingConfigurationInstancePatternInfo(
    public val architectures: List<String>? = null,
    public val burstablePerformance: String? = null,
    public val cores: Int? = null,
    public val excludedInstanceTypes: List<String>? = null,
    public val instanceFamilyLevel: String? = null,
    public val maxPrice: Double? = null,
    public val memory: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.ScalingConfigurationInstancePatternInfo): ScalingConfigurationInstancePatternInfo = ScalingConfigurationInstancePatternInfo(
            architectures = javaType.architectures().map({ args0 -> args0 }),
            burstablePerformance = javaType.burstablePerformance().map({ args0 -> args0 }).orElse(null),
            cores = javaType.cores().map({ args0 -> args0 }).orElse(null),
            excludedInstanceTypes = javaType.excludedInstanceTypes().map({ args0 -> args0 }),
            instanceFamilyLevel = javaType.instanceFamilyLevel().map({ args0 -> args0 }).orElse(null),
            maxPrice = javaType.maxPrice().map({ args0 -> args0 }).orElse(null),
            memory = javaType.memory().map({ args0 -> args0 }).orElse(null),
        )
    }
}
