@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property instanceType The is specified for an instance type in instanceTypeOverride.
 * @property weightedCapacity The weight of instance type in instanceTypeOverride.
 */
public data class ScalingConfigurationInstanceTypeOverride(
    public val instanceType: String? = null,
    public val weightedCapacity: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.ScalingConfigurationInstanceTypeOverride): ScalingConfigurationInstanceTypeOverride = ScalingConfigurationInstanceTypeOverride(
            instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
            weightedCapacity = javaType.weightedCapacity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
