@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property instanceType Resource type of an ECS instance.
 * @property priceLimit Price limit hourly of instance type, 2 decimals is allowed at most.
 */
public data class ScalingConfigurationSpotPriceLimit(
    public val instanceType: String? = null,
    public val priceLimit: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.ScalingConfigurationSpotPriceLimit): ScalingConfigurationSpotPriceLimit = ScalingConfigurationSpotPriceLimit(
            instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
            priceLimit = javaType.priceLimit().map({ args0 -> args0 }).orElse(null),
        )
    }
}
