@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property albServerGroupId The ID of ALB server group.
 * @property port The port number used by an ECS instance after Auto Scaling adds the ECS instance to ALB server group.
 * @property weight The weight of the ECS instance as a backend server after Auto Scaling adds the ECS instance to ALB server group.
 */
public data class ScalingGroupAlbServerGroup(
    public val albServerGroupId: String? = null,
    public val port: Int? = null,
    public val weight: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.ScalingGroupAlbServerGroup): ScalingGroupAlbServerGroup = ScalingGroupAlbServerGroup(
            albServerGroupId = javaType.albServerGroupId().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            weight = javaType.weight().map({ args0 -> args0 }).orElse(null),
        )
    }
}
