@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property instanceType The instance type in launchTemplateOverride.
 * @property spotPriceLimit The maximum bid price of instance type in launchTemplateOverride.
 * > **NOTE:** When detach loadbalancers, instances in group will be remove from loadbalancer's `Default Server Group`; On the contrary, When attach loadbalancers, instances in group will be added to loadbalancer's `Default Server Group`.
 * > **NOTE:** When detach dbInstances, private ip of instances in group will be remove from dbInstance's `WhiteList`; On the contrary, When attach dbInstances, private ip of instances in group will be added to dbInstance's `WhiteList`.
 * > **NOTE:** `on_demand_base_capacity`,`on_demand_percentage_above_base_capacity`,`spot_instance_pools`,`spot_instance_remedy` are valid only if `multi_az_policy` is 'COST_OPTIMIZED'.
 * @property weightedCapacity The weight of the instance type in launchTemplateOverride.
 */
public data class ScalingGroupLaunchTemplateOverride(
    public val instanceType: String? = null,
    public val spotPriceLimit: Double? = null,
    public val weightedCapacity: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.ScalingGroupLaunchTemplateOverride): ScalingGroupLaunchTemplateOverride = ScalingGroupLaunchTemplateOverride(
            instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
            spotPriceLimit = javaType.spotPriceLimit().map({ args0 -> args0 }).orElse(null),
            weightedCapacity = javaType.weightedCapacity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
