@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property metricIntervalLowerBound The lower bound of step.
 * @property metricIntervalUpperBound The upper bound of step.
 * @property scalingAdjustment The adjust value of step.
 */
public data class ScalingRuleStepAdjustment(
    public val metricIntervalLowerBound: String? = null,
    public val metricIntervalUpperBound: String? = null,
    public val scalingAdjustment: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ess.outputs.ScalingRuleStepAdjustment): ScalingRuleStepAdjustment = ScalingRuleStepAdjustment(
            metricIntervalLowerBound = javaType.metricIntervalLowerBound().map({ args0 -> args0 }).orElse(null),
            metricIntervalUpperBound = javaType.metricIntervalUpperBound().map({ args0 -> args0 }).orElse(null),
            scalingAdjustment = javaType.scalingAdjustment().map({ args0 -> args0 }).orElse(null),
        )
    }
}
