@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin

import com.pulumi.alicloud.eventbridge.kotlin.outputs.ApiDestinationHttpApiParameters
import com.pulumi.alicloud.eventbridge.kotlin.outputs.ApiDestinationHttpApiParameters.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ApiDestination].
 */
@PulumiTagMarker
public class ApiDestinationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApiDestinationArgs = ApiDestinationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApiDestinationArgsBuilder.() -> Unit) {
        val builder = ApiDestinationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ApiDestination {
        val builtJavaResource = com.pulumi.alicloud.eventbridge.ApiDestination(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ApiDestination(builtJavaResource)
    }
}

/**
 * Provides a Event Bridge Api Destination resource.
 * For information about Event Bridge Api Destination and how to use it, see [What is Api Destination](https://www.alibabacloud.com/help/en/eventbridge/latest/api-eventbridge-2020-04-01-createapidestination).
 * > **NOTE:** Available since v1.211.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const region = config.get("region") || "cn-chengdu";
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.eventbridge.Connection("default", {
 *     connectionName: name,
 *     networkParameters: {
 *         networkType: "PublicNetwork",
 *     },
 * });
 * const defaultApiDestination = new alicloud.eventbridge.ApiDestination("default", {
 *     connectionName: _default.connectionName,
 *     apiDestinationName: name,
 *     description: "test-api-destination-connection",
 *     httpApiParameters: {
 *         endpoint: "http://127.0.0.1:8001",
 *         method: "POST",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * region = config.get("region")
 * if region is None:
 *     region = "cn-chengdu"
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.eventbridge.Connection("default",
 *     connection_name=name,
 *     network_parameters={
 *         "network_type": "PublicNetwork",
 *     })
 * default_api_destination = alicloud.eventbridge.ApiDestination("default",
 *     connection_name=default.connection_name,
 *     api_destination_name=name,
 *     description="test-api-destination-connection",
 *     http_api_parameters={
 *         "endpoint": "http://127.0.0.1:8001",
 *         "method": "POST",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var region = config.Get("region") ?? "cn-chengdu";
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.EventBridge.Connection("default", new()
 *     {
 *         ConnectionName = name,
 *         NetworkParameters = new AliCloud.EventBridge.Inputs.ConnectionNetworkParametersArgs
 *         {
 *             NetworkType = "PublicNetwork",
 *         },
 *     });
 *     var defaultApiDestination = new AliCloud.EventBridge.ApiDestination("default", new()
 *     {
 *         ConnectionName = @default.ConnectionName,
 *         ApiDestinationName = name,
 *         Description = "test-api-destination-connection",
 *         HttpApiParameters = new AliCloud.EventBridge.Inputs.ApiDestinationHttpApiParametersArgs
 *         {
 *             Endpoint = "http://127.0.0.1:8001",
 *             Method = "POST",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eventbridge"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		region := "cn-chengdu"
 * 		if param := cfg.Get("region"); param != "" {
 * 			region = param
 * 		}
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := eventbridge.NewConnection(ctx, "default", &eventbridge.ConnectionArgs{
 * 			ConnectionName: pulumi.String(name),
 * 			NetworkParameters: &eventbridge.ConnectionNetworkParametersArgs{
 * 				NetworkType: pulumi.String("PublicNetwork"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = eventbridge.NewApiDestination(ctx, "default", &eventbridge.ApiDestinationArgs{
 * 			ConnectionName:     _default.ConnectionName,
 * 			ApiDestinationName: pulumi.String(name),
 * 			Description:        pulumi.String("test-api-destination-connection"),
 * 			HttpApiParameters: &eventbridge.ApiDestinationHttpApiParametersArgs{
 * 				Endpoint: pulumi.String("http://127.0.0.1:8001"),
 * 				Method:   pulumi.String("POST"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.eventbridge.Connection;
 * import com.pulumi.alicloud.eventbridge.ConnectionArgs;
 * import com.pulumi.alicloud.eventbridge.inputs.ConnectionNetworkParametersArgs;
 * import com.pulumi.alicloud.eventbridge.ApiDestination;
 * import com.pulumi.alicloud.eventbridge.ApiDestinationArgs;
 * import com.pulumi.alicloud.eventbridge.inputs.ApiDestinationHttpApiParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var region = config.get("region").orElse("cn-chengdu");
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Connection("default", ConnectionArgs.builder()
 *             .connectionName(name)
 *             .networkParameters(ConnectionNetworkParametersArgs.builder()
 *                 .networkType("PublicNetwork")
 *                 .build())
 *             .build());
 *         var defaultApiDestination = new ApiDestination("defaultApiDestination", ApiDestinationArgs.builder()
 *             .connectionName(default_.connectionName())
 *             .apiDestinationName(name)
 *             .description("test-api-destination-connection")
 *             .httpApiParameters(ApiDestinationHttpApiParametersArgs.builder()
 *                 .endpoint("http://127.0.0.1:8001")
 *                 .method("POST")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   region:
 *     type: string
 *     default: cn-chengdu
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:eventbridge:Connection
 *     properties:
 *       connectionName: ${name}
 *       networkParameters:
 *         networkType: PublicNetwork
 *   defaultApiDestination:
 *     type: alicloud:eventbridge:ApiDestination
 *     name: default
 *     properties:
 *       connectionName: ${default.connectionName}
 *       apiDestinationName: ${name}
 *       description: test-api-destination-connection
 *       httpApiParameters:
 *         endpoint: http://127.0.0.1:8001
 *         method: POST
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Event Bridge Api Destination can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eventbridge/apiDestination:ApiDestination example <id>
 * ```
 */
public class ApiDestination internal constructor(
    override val javaResource: com.pulumi.alicloud.eventbridge.ApiDestination,
) : KotlinCustomResource(javaResource, ApiDestinationMapper) {
    /**
     * The name of the API destination.
     */
    public val apiDestinationName: Output<String>
        get() = javaResource.apiDestinationName().applyValue({ args0 -> args0 })

    /**
     * The name of the connection.
     */
    public val connectionName: Output<String>
        get() = javaResource.connectionName().applyValue({ args0 -> args0 })

    /**
     * The creation time of the Api Destination.
     */
    public val createTime: Output<Int>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The description of the API destination.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The parameters that are configured for the API destination. See `http_api_parameters` below.
     */
    public val httpApiParameters: Output<ApiDestinationHttpApiParameters>
        get() = javaResource.httpApiParameters().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })
}

public object ApiDestinationMapper : ResourceMapper<ApiDestination> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.eventbridge.ApiDestination::class == javaResource::class

    override fun map(javaResource: Resource): ApiDestination = ApiDestination(
        javaResource as
            com.pulumi.alicloud.eventbridge.ApiDestination,
    )
}

/**
 * @see [ApiDestination].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApiDestination].
 */
public suspend fun apiDestination(
    name: String,
    block: suspend ApiDestinationResourceBuilder.() -> Unit,
): ApiDestination {
    val builder = ApiDestinationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApiDestination].
 * @param name The _unique_ name of the resulting resource.
 */
public fun apiDestination(name: String): ApiDestination {
    val builder = ApiDestinationResourceBuilder()
    builder.name(name)
    return builder.build()
}
