@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin

import com.pulumi.alicloud.eventbridge.ApiDestinationArgs.builder
import com.pulumi.alicloud.eventbridge.kotlin.inputs.ApiDestinationHttpApiParametersArgs
import com.pulumi.alicloud.eventbridge.kotlin.inputs.ApiDestinationHttpApiParametersArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a Event Bridge Api Destination resource.
 * For information about Event Bridge Api Destination and how to use it, see [What is Api Destination](https://www.alibabacloud.com/help/en/eventbridge/latest/api-eventbridge-2020-04-01-createapidestination).
 * > **NOTE:** Available since v1.211.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const region = config.get("region") || "cn-chengdu";
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.eventbridge.Connection("default", {
 *     connectionName: name,
 *     networkParameters: {
 *         networkType: "PublicNetwork",
 *     },
 * });
 * const defaultApiDestination = new alicloud.eventbridge.ApiDestination("default", {
 *     connectionName: _default.connectionName,
 *     apiDestinationName: name,
 *     description: "test-api-destination-connection",
 *     httpApiParameters: {
 *         endpoint: "http://127.0.0.1:8001",
 *         method: "POST",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * region = config.get("region")
 * if region is None:
 *     region = "cn-chengdu"
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.eventbridge.Connection("default",
 *     connection_name=name,
 *     network_parameters={
 *         "network_type": "PublicNetwork",
 *     })
 * default_api_destination = alicloud.eventbridge.ApiDestination("default",
 *     connection_name=default.connection_name,
 *     api_destination_name=name,
 *     description="test-api-destination-connection",
 *     http_api_parameters={
 *         "endpoint": "http://127.0.0.1:8001",
 *         "method": "POST",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var region = config.Get("region") ?? "cn-chengdu";
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.EventBridge.Connection("default", new()
 *     {
 *         ConnectionName = name,
 *         NetworkParameters = new AliCloud.EventBridge.Inputs.ConnectionNetworkParametersArgs
 *         {
 *             NetworkType = "PublicNetwork",
 *         },
 *     });
 *     var defaultApiDestination = new AliCloud.EventBridge.ApiDestination("default", new()
 *     {
 *         ConnectionName = @default.ConnectionName,
 *         ApiDestinationName = name,
 *         Description = "test-api-destination-connection",
 *         HttpApiParameters = new AliCloud.EventBridge.Inputs.ApiDestinationHttpApiParametersArgs
 *         {
 *             Endpoint = "http://127.0.0.1:8001",
 *             Method = "POST",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eventbridge"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		region := "cn-chengdu"
 * 		if param := cfg.Get("region"); param != "" {
 * 			region = param
 * 		}
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := eventbridge.NewConnection(ctx, "default", &eventbridge.ConnectionArgs{
 * 			ConnectionName: pulumi.String(name),
 * 			NetworkParameters: &eventbridge.ConnectionNetworkParametersArgs{
 * 				NetworkType: pulumi.String("PublicNetwork"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = eventbridge.NewApiDestination(ctx, "default", &eventbridge.ApiDestinationArgs{
 * 			ConnectionName:     _default.ConnectionName,
 * 			ApiDestinationName: pulumi.String(name),
 * 			Description:        pulumi.String("test-api-destination-connection"),
 * 			HttpApiParameters: &eventbridge.ApiDestinationHttpApiParametersArgs{
 * 				Endpoint: pulumi.String("http://127.0.0.1:8001"),
 * 				Method:   pulumi.String("POST"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.eventbridge.Connection;
 * import com.pulumi.alicloud.eventbridge.ConnectionArgs;
 * import com.pulumi.alicloud.eventbridge.inputs.ConnectionNetworkParametersArgs;
 * import com.pulumi.alicloud.eventbridge.ApiDestination;
 * import com.pulumi.alicloud.eventbridge.ApiDestinationArgs;
 * import com.pulumi.alicloud.eventbridge.inputs.ApiDestinationHttpApiParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var region = config.get("region").orElse("cn-chengdu");
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Connection("default", ConnectionArgs.builder()
 *             .connectionName(name)
 *             .networkParameters(ConnectionNetworkParametersArgs.builder()
 *                 .networkType("PublicNetwork")
 *                 .build())
 *             .build());
 *         var defaultApiDestination = new ApiDestination("defaultApiDestination", ApiDestinationArgs.builder()
 *             .connectionName(default_.connectionName())
 *             .apiDestinationName(name)
 *             .description("test-api-destination-connection")
 *             .httpApiParameters(ApiDestinationHttpApiParametersArgs.builder()
 *                 .endpoint("http://127.0.0.1:8001")
 *                 .method("POST")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   region:
 *     type: string
 *     default: cn-chengdu
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:eventbridge:Connection
 *     properties:
 *       connectionName: ${name}
 *       networkParameters:
 *         networkType: PublicNetwork
 *   defaultApiDestination:
 *     type: alicloud:eventbridge:ApiDestination
 *     name: default
 *     properties:
 *       connectionName: ${default.connectionName}
 *       apiDestinationName: ${name}
 *       description: test-api-destination-connection
 *       httpApiParameters:
 *         endpoint: http://127.0.0.1:8001
 *         method: POST
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Event Bridge Api Destination can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eventbridge/apiDestination:ApiDestination example <id>
 * ```
 * @property apiDestinationName The name of the API destination.
 * @property connectionName The name of the connection.
 * @property description The description of the API destination.
 * @property httpApiParameters The parameters that are configured for the API destination. See `http_api_parameters` below.
 */
public data class ApiDestinationArgs(
    public val apiDestinationName: Output<String>? = null,
    public val connectionName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val httpApiParameters: Output<ApiDestinationHttpApiParametersArgs>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eventbridge.ApiDestinationArgs> {
    override fun toJava(): com.pulumi.alicloud.eventbridge.ApiDestinationArgs =
        com.pulumi.alicloud.eventbridge.ApiDestinationArgs.builder()
            .apiDestinationName(apiDestinationName?.applyValue({ args0 -> args0 }))
            .connectionName(connectionName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .httpApiParameters(
                httpApiParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ApiDestinationArgs].
 */
@PulumiTagMarker
public class ApiDestinationArgsBuilder internal constructor() {
    private var apiDestinationName: Output<String>? = null

    private var connectionName: Output<String>? = null

    private var description: Output<String>? = null

    private var httpApiParameters: Output<ApiDestinationHttpApiParametersArgs>? = null

    /**
     * @param value The name of the API destination.
     */
    @JvmName("eblswwwygydedawn")
    public suspend fun apiDestinationName(`value`: Output<String>) {
        this.apiDestinationName = value
    }

    /**
     * @param value The name of the connection.
     */
    @JvmName("wfeecrguewuahfiy")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value The description of the API destination.
     */
    @JvmName("trtjwkaoykisrgjh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The parameters that are configured for the API destination. See `http_api_parameters` below.
     */
    @JvmName("qbhtyxnrnqsklely")
    public suspend fun httpApiParameters(`value`: Output<ApiDestinationHttpApiParametersArgs>) {
        this.httpApiParameters = value
    }

    /**
     * @param value The name of the API destination.
     */
    @JvmName("jjffixeivkjidpcg")
    public suspend fun apiDestinationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiDestinationName = mapped
    }

    /**
     * @param value The name of the connection.
     */
    @JvmName("edlubupkaxiwcolx")
    public suspend fun connectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value The description of the API destination.
     */
    @JvmName("dsjdvllrkwlsxtdr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The parameters that are configured for the API destination. See `http_api_parameters` below.
     */
    @JvmName("cyuklvpjnkkvpofx")
    public suspend fun httpApiParameters(`value`: ApiDestinationHttpApiParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpApiParameters = mapped
    }

    /**
     * @param argument The parameters that are configured for the API destination. See `http_api_parameters` below.
     */
    @JvmName("lxyvvnuprtfggmbu")
    public suspend fun httpApiParameters(argument: suspend ApiDestinationHttpApiParametersArgsBuilder.() -> Unit) {
        val toBeMapped = ApiDestinationHttpApiParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpApiParameters = mapped
    }

    internal fun build(): ApiDestinationArgs = ApiDestinationArgs(
        apiDestinationName = apiDestinationName,
        connectionName = connectionName,
        description = description,
        httpApiParameters = httpApiParameters,
    )
}
