@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eventbridge.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EventBus].
 */
@PulumiTagMarker
public class EventBusResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventBusArgs = EventBusArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventBusArgsBuilder.() -> Unit) {
        val builder = EventBusArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EventBus {
        val builtJavaResource = com.pulumi.alicloud.eventbridge.EventBus(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventBus(builtJavaResource)
    }
}

/**
 * Provides a Event Bridge Event Bus resource.
 * For information about Event Bridge Event Bus and how to use it, see [What is Event Bus](https://www.alibabacloud.com/help/en/eventbridge/latest/api-eventbridge-2020-04-01-createeventbus).
 * > **NOTE:** Available since v1.129.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const example = new alicloud.eventbridge.EventBus("example", {eventBusName: name});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * example = alicloud.eventbridge.EventBus("example", event_bus_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var example = new AliCloud.EventBridge.EventBus("example", new()
 *     {
 *         EventBusName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eventbridge"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := eventbridge.NewEventBus(ctx, "example", &eventbridge.EventBusArgs{
 * 			EventBusName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.eventbridge.EventBus;
 * import com.pulumi.alicloud.eventbridge.EventBusArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var example = new EventBus("example", EventBusArgs.builder()
 *             .eventBusName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   example:
 *     type: alicloud:eventbridge:EventBus
 *     properties:
 *       eventBusName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Event Bridge Event Bus can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eventbridge/eventBus:EventBus example <event_bus_name>
 * ```
 */
public class EventBus internal constructor(
    override val javaResource: com.pulumi.alicloud.eventbridge.EventBus,
) : KotlinCustomResource(javaResource, EventBusMapper) {
    /**
     * The description of event bus.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of event bus. The length is limited to 2 ~ 127 characters, which can be composed of letters, numbers or hyphens (-)
     */
    public val eventBusName: Output<String>
        get() = javaResource.eventBusName().applyValue({ args0 -> args0 })
}

public object EventBusMapper : ResourceMapper<EventBus> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.eventbridge.EventBus::class == javaResource::class

    override fun map(javaResource: Resource): EventBus = EventBus(
        javaResource as
            com.pulumi.alicloud.eventbridge.EventBus,
    )
}

/**
 * @see [EventBus].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventBus].
 */
public suspend fun eventBus(name: String, block: suspend EventBusResourceBuilder.() -> Unit): EventBus {
    val builder = EventBusResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventBus].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventBus(name: String): EventBus {
    val builder = EventBusResourceBuilder()
    builder.name(name)
    return builder.build()
}
